% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-query.R
\name{combine_parent_and_child_resultsets}
\alias{combine_parent_and_child_resultsets}
\title{Bind the records from nested parent-to-child queries}
\usage{
combine_parent_and_child_resultsets(parents_df, child_df_list)
}
\arguments{
\item{parents_df}{\code{tbl_df}; a dataset with 1 row per parent record from
the query recordset, that can be joined with its corresponding child records.}

\item{child_df_list}{\code{list} of \code{tbl_df}; a list of child records that
is the same length as the number of rows in the parent_df.}
}
\value{
\code{tbl_df}; a data frame of parent data replicated for each child
record in the corresponding list.
}
\description{
This function accepts a \code{data.frame} with one row representing each
parent record returned by a query with a corresponding list element in the
list of child record results stored as \code{tbl_df} in a list.
}
\note{
This function is meant to be used internally. Only use when debugging.
}
\keyword{internal}
