% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete-metadata.R
\name{sf_delete_metadata}
\alias{sf_delete_metadata}
\title{Delete Object or Field Metadata in Salesforce}
\usage{
sf_delete_metadata(
  metadata_type,
  object_names,
  control = list(...),
  ...,
  verbose = FALSE
)
}
\arguments{
\item{metadata_type}{character; string on what type of metadata to create}

\item{object_names}{a character vector of names that we wish to read metadata for}

\item{control}{\code{list}; a list of parameters for controlling the behavior of 
the API call being used. For more information of what parameters are available 
look at the documentation for \code{\link{sf_control}}}

\item{...}{arguments passed to \code{\link{sf_control}}}

\item{verbose}{logical; do you want informative messages?}
}
\value{
A \code{data.frame} containing the creation result for each submitted metadata component
}
\description{
This function takes a request of named elements in Salesforce and deletes them.
}
\examples{
\dontrun{
metadata_info <- sf_delete_metadata(metadata_type = 'CustomObject', 
                                    object_names = c('Custom_Account25__c'))
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta/}
}
\seealso{
\link{sf_list_metadata}
}
