% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeMeta.R
\name{makeMeta}
\alias{makeMeta}
\title{Create a metadata object table for a set of charts}
\usage{
makeMeta(charts)
}
\arguments{
\item{charts}{list of safetyGraphics chart objects for which to create metadata}
}
\value{
tibble of metadata with the following columns:
\describe{
\item{domain}{Data domain}
\item{text_key}{Text key indicating the setting name. \code{'--'} delimiter indicates a field level data mapping}
\item{col_key}{Key for the column mapping}
\item{field_key}{Key for the field mapping (if any)}
\item{type}{type of mapping - "field" or "column"}
\item{label}{Label}
\item{description}{Description}
\item{multiple}{Mapping supports multiple columns/fields }
\item{standard_adam}{Default values for the ADaM data standard}
\item{standard_sdtm}{Default values for the SDTM data standard}
}
}
\description{
Generates metadata object for a list of charts. \code{makeMeta()} looks for metadata in 3 locations for each \code{chart} object:
\itemize{
\item Domain-level metadata saved as meta_{chart$name} in the chart$package namespace
\item Chart-specific metadata saved as meta_{chart$domain} in the chart$package namespace
\item Chart-specific metadata saved directly to the chart object as chart$meta
After checking all charts, all metadata files are stacked in to a single dataframe and returned. If duplicate metadata rows (domain + text_key) are found, an error is thrown.
}
}
