% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safe2x2Test.R
\name{simulateIncorrectStoppingTimesFisher}
\alias{simulateIncorrectStoppingTimesFisher}
\title{Simulate incorrect optional stopping with fisher's exact test's p-value as the
stopping rule.}
\usage{
simulateIncorrectStoppingTimesFisher(
  thetaA,
  thetaB,
  alpha,
  na,
  nb,
  maxSimStoptime = 10000,
  M = 1000,
  numberForSeed = NULL
)
}
\arguments{
\item{thetaA}{Bernoulli distribution parameter in group A}

\item{thetaB}{Bernoulli distribution parameter in group B}

\item{alpha}{Significance level}

\item{na}{number of observations in group a per data block}

\item{nb}{number of observations in group b per data block}

\item{maxSimStoptime}{maximal number of blocks to sample in each experiment}

\item{M}{Number of simulations to carry out, default 1e3.}

\item{numberForSeed}{number for seed to set, default NULL.}
}
\value{
list with stopping times and rejection decisions.
}
\description{
Simulate incorrect optional stopping with fisher's exact test's p-value as the
stopping rule.
}
\examples{
simulateIncorrectStoppingTimesFisher(thetaA = 0.3,
                                     thetaB = 0.3,
                                     alpha = 0.05,
                                     na = 1,
                                     nb = 1,
                                     M = 10,
                                     maxSimStoptime = 100,
                                     numberForSeed = 251)
}
