% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logRankTest.R
\name{rLogrank}
\alias{rLogrank}
\title{Randomly samples from a logrank distribution}
\usage{
rLogrank(n = 1, y0, y1, obsTotal, theta)
}
\arguments{
\item{n}{integer, number of observations to be sampled.}

\item{y0}{Size of the risk set of group 0 (Placebo).}

\item{y1}{Size of the risk set of group 1 (Treatment).}

\item{obsTotal}{Total number of observations.}

\item{theta}{Odds of group 1 over group 0 (treatment over placebo).}
}
\value{
integer representing the number of occurences in group 1 out of
obsTotal number of occurences.
}
\description{
Draws a number of occurences in group 1 (treatment) out of
obsTotal number of occurences.
}
\examples{
rLogrank(y0=360, y1=89, obsTotal=12, theta=3.14)

}
\author{
Muriel Felipe Perez-Ortiz and Alexander Ly
}
