% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file.R
\name{decrypt_file}
\alias{decrypt_file}
\title{Decrypt a connection or file}
\usage{
decrypt_file(infile, outfile, ascii = FALSE, key = "pass",
  method = "symmetric")
}
\arguments{
\item{infile}{Encrypted file.}

\item{outfile}{A non-existant file where the decrypted output will be
written.}

\item{ascii}{\code{TRUE} if the outfile is a ascii file. Default is
\code{FALSE}}

\item{key}{A string without embbeded NULL. Default is 'pass'.}

\item{method}{Currently, a stub. It should be 'symmetric'(default).}
}
\value{
An invisible TRUE
}
\description{
\code{decrypt_file}) decrypts a binary or a text file back to a
  file.
}
\examples{
write.table(iris, "iris.csv")
all(
  encrypt_file("iris.csv", "iris_encrypted.bin")
  , file.exists("iris_encrypted.bin")
  , decrypt_file("iris_encrypted.bin", "iris_2.csv")
  , file.exists("iris_2.csv")
  , tools::md5sum("iris_2.csv") == tools::md5sum("iris.csv")
  , unlink("iris.csv") == 0
  , unlink("iris_2.csv") == 0
  , unlink("iris_encrypted.bin") == 0
)

write.table(iris, "iris.csv")
all(
  encrypt_file("iris.csv", "iris_encrypted.txt", ascii = TRUE)
  , file.exists("iris_encrypted.txt")
  , decrypt_file("iris_encrypted.txt", "iris_2.csv", ascii = TRUE)
  , file.exists("iris_2.csv")
  , tools::md5sum("iris_2.csv") == tools::md5sum("iris.csv")
  , unlink("iris.csv") == 0
  , unlink("iris_2.csv") == 0
  , unlink("iris_encrypted.txt") == 0
)

}
