% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safe_left_join.R
\name{safe_left_join}
\alias{safe_left_join}
\title{Validate extra rows are added not added to the left hand side}
\usage{
safe_left_join(..., action = "error", relationship = "*:1")
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[dplyr:mutate-joins]{dplyr::left_join}}
  \describe{
    \item{\code{x}}{A pair of data frames, data frame extensions (e.g. a tibble), or
lazy data frames (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}
    \item{\code{y}}{A pair of data frames, data frame extensions (e.g. a tibble), or
lazy data frames (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}
    \item{\code{by}}{A character vector of variables to join by.

If \code{NULL}, the default, \verb{*_join()} will perform a natural join, using all
variables in common across \code{x} and \code{y}. A message lists the variables so that you
can check they're correct; suppress the message by supplying \code{by} explicitly.

To join by different variables on \code{x} and \code{y}, use a named vector.
For example, \code{by = c("a" = "b")} will match \code{x$a} to \code{y$b}.

To join by multiple variables, use a vector with length > 1.
For example, \code{by = c("a", "b")} will match \code{x$a} to \code{y$a} and \code{x$b} to
\code{y$b}. Use a named vector to match different variables in \code{x} and \code{y}.
For example, \code{by = c("a" = "b", "c" = "d")} will match \code{x$a} to \code{y$b} and
\code{x$c} to \code{y$d}.

To perform a cross-join, generating all combinations of \code{x} and \code{y},
use \code{by = character()}.}
    \item{\code{copy}}{If \code{x} and \code{y} are not from the same data source,
and \code{copy} is \code{TRUE}, then \code{y} will be copied into the
same src as \code{x}.  This allows you to join tables across srcs, but
it is a potentially expensive operation so you must opt into it.}
    \item{\code{suffix}}{If there are non-joined duplicate variables in \code{x} and
\code{y}, these suffixes will be added to the output to disambiguate them.
Should be a character vector of length 2.}
    \item{\code{keep}}{Should the join keys from both \code{x} and \code{y} be preserved in the
output?}
  }}

\item{action}{What should happen when the number of rows changes from a join?
Options include: 'error', 'warning', or 'message'. By default 'error'.}

\item{relationship}{What is the expected relationship between `x` and `y`?
At this time the only available option is '*:1', indicating a many to one
relationship between `x` and `y`. In the future more options may be added.}
}
\value{
An object of the same type as `x`. The order of the rows and columns of `x`
is preserved as much as possible. The output has the following properties:
}
\description{
Perform a "safe" left join where it is guaranteed that no additional rows are
added to the left hand side table. For more information on left joins see 
(\code{\link[dplyr:left_join]{dplyr::left_join}}).
}
\examples{
# The relationship between `x` and `y` is '*:1'. No extra rows will be added
# to the left hand side.
x <- data.frame(key = c("a", "a", "b"), value_x = c(1, 4, 2))
y <- data.frame(key = c("a", "b"), value_y = c(1, 1))
safe_left_join(x, y)

# The relationship between `x` and `y` is '1:*'. An error should be raised
# because additional rows will be added to the left hand side.
\dontrun{x <- data.frame(key = c("a", "b"), value_x = c(1, 2))
y <- data.frame(key = c("a", "a"), value_y = c(1, 1))
safe_left_join(x, y)}

# Alternatively instead of raising an error a warning or message can be
# outputted.
x <- data.frame(key = c("a", "b"), value_x = c(1, 2))
y <- data.frame(key = c("a", "a"), value_y = c(1, 1))
safe_left_join(x, y, action = "warning")
safe_left_join(x, y, action = "message")
}
