% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SaemixRes.R
\docType{class}
\name{SaemixRes-class}
\alias{SaemixRes}
\alias{SaemixRes-class}
\title{Class "SaemixRes"}
\description{
An object of the SaemixRes class, representing the results of a fit through the SAEM algorithm.
}
\section{Objects from the Class}{

An object of the SaemixRes class is returned as part of a SaemixObject object after a call to \code{\link{saemix}} and contain the following slots:
  \describe{
    \item{\code{name.fixed}:}{a vector containing the names of the fixed parameters in the model}
    }
}

\section{Methods}{

  \describe{
    \item{[<-}{\code{signature(x = "SaemixRes")}: replace elements of object}
    \item{[}{\code{signature(x = "SaemixRes")}: access elements of object}
    \item{initialize}{\code{signature(.Object = "SaemixRes")}: internal function to initialise object, not to be used}
    \item{print}{\code{signature(x = "SaemixRes")}: prints details about the object (more extensive than show)}
    \item{read}{\code{signature(object = "SaemixRes")}: internal function, not to be used }
    \item{showall}{\code{signature(object = "SaemixRes")}: shows all the elements in the object}
    \item{show}{\code{signature(object = "SaemixRes")}: prints details about the object}
    \item{summary}{\code{signature(object = "SaemixRes")}: summary of the results. Returns a list with a number of elements extracted from the results ().}
	 }
}
\examples{
methods(class="SaemixRes")

showClass("SaemixRes")
}
\author{
Emmanuelle Comets \email{emmanuelle.comets@inserm.fr}

Audrey Lavenu

Marc Lavielle.
}
\references{
Kuhn E, Lavielle M. Maximum likelihood estimation in nonlinear mixed effects models. Computational Statistics and Data Analysis (2005), 49(4):1020-38.

Comets E, Lavenu A, Lavielle M. Parameter Estimation in Nonlinear Mixed Effect Models Using saemix, an R Implementation of the SAEM Algorithm. Journal of Statistical Software (2017), 80(3):1-41. doi:10.18637/jss.v080.i03
}
\seealso{
\code{\link{saemixData}} \code{\link{SaemixModel}} \code{\link{saemixControl}} \code{\link{saemix}}
}
\keyword{classes}

