% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{df_susenas_sep2020}
\alias{df_susenas_sep2020}
\title{df_susenas_sep2020: September 2020 National Socio-Economic Survey (Susenas) Dataset for DKI Jakarta, Indonesia}
\format{
A data frame with 3655 rows and 33 variables with 6 domains.

\describe{
  \item{ID}{Unique identifier for each respondent}
  \item{no_sample}{Sample number}
  \item{no_household}{Household number}
  \item{no_member}{Household member number}
  \item{weight}{Weight from survey}
  \item{province}{Province code}
  \item{urban_rural}{Urban or rural classification (1: Urban, 2: Rural)}
  \item{marital_status}{Marital status (1: Married, 0: Other)}
  \item{sex}{Sex (1: Male, 2: Female)}
  \item{age}{Age of the respondent}
  \item{attending_school}{Currently attending school (0: No, 1: Yes)}
  \item{highest_edu}{Highest education completed (0: Did not complete elementary school, 1: Elementary school, 2: Junior high school, 3: Senior high school, 4: University/College)}
  \item{job_status}{Employment status (1: Employed, 0: Not employed)}
  \item{sector_type}{Type of employment sector (1: Agriculture, 0: Non-agriculture)}
  \item{job_position}{Job position or role}
  \item{building_ownership}{Ownership status of residence (1: Owned, 0: Other)}
  \item{floor_area}{Floor area of residence (in square meters)}
  \item{pension_ins}{Has pension insurance (0: No, 1: Yes)}
  \item{old_age_ins}{Has old-age insurance (0: No, 1: Yes)}
  \item{work_ins}{Has work insurance (0: No, 1: Yes)}
  \item{life_ins}{Has life insurance (0: No, 1: Yes)}
  \item{severance_pay}{Receives severance pay (0: No, 1: Yes)}
  \item{kks_card}{Has a KKS (Kartu Keluarga Sejahtera) card (0: No, 1: Yes)}
  \item{pkh_recipient}{Is the respondent a recipient of PKH (Program Keluarga Harapan) assistance? (0: No, 1: Yes)}
  \item{pkh_disbursement}{Location where PKH funds are disbursed}
  \item{pkh_food}{PKH funds used for food assistance (0: No, 1: Yes)}
  \item{pkh_housing}{PKH funds used for housing assistance (0: No, 1: Yes)}
  \item{pkh_healthcare}{PKH funds used for healthcare assistance (0: No, 1: Yes)}
  \item{pkh_maternity}{PKH funds used for maternity assistance (0: No, 1: Yes)}
  \item{pkh_school}{PKH funds used for school assistance (0: No, 1: Yes)}
  \item{pkh_other}{PKH funds used for other types of assistance (0: No, 1: Yes)}
  \item{bpnt_program}{Receives BPNT (Bantuan Pangan Non-Tunai) program assistance (0: No, 1: Yes)}
  \item{uses_public_transport}{Using public transportation (0: No, 1: Yes), which includes motorized vehicles with specific routes}
}
}
\source{
\url{https://www.bps.go.id}
}
\usage{
df_susenas_sep2020
}
\description{
A dataset from the September 2020 National Socio-Economic Survey (Susenas) Social Resilience Module, conducted in DKI Jakarta, Indonesia, which is held every three years, presented at the provincial level.
}
\keyword{datasets}
