% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SABARSI.R
\name{background_removal}
\alias{background_removal}
\title{Perform background removal on the whole SERS spectrum data set.
Divide the SERS spectrum data into time-frequency blocks and remove background locally.}
\usage{
background_removal(x, q = 0.4, w.chan = 50, w.time = 50)
}
\arguments{
\item{x}{A p*n data matrix. There are n SERS spectra with p frequency channels.}

\item{q}{A number taking value between 0 and 1. 100*q is the quantile that SABARSI uses to calculate the spectrum strength.}

\item{w.chan}{The window size for the frequency domain. The default value of \code{w.chan} is 50.}

\item{w.time}{The window size for the time domain. The default value of \code{w.time} is 50.}
}
\value{
A p*n data matrix, \code{xr}, of background-removed spectra.
}
\description{
Perform background removal on the whole SERS spectrum data set.
Divide the SERS spectrum data into time-frequency blocks and remove background locally.
}
\examples{
data(SERS)
x <- SERS$R1   ## x is the matrix of SERS spectra
xr <- background_removal(x) ## xr is the matrix of background removed spectra
}
