% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_system.R
\name{upload}
\alias{upload}
\alias{s3_file_upload}
\alias{s3_dir_upload}
\title{Upload file and directory}
\usage{
s3_file_upload(
  path,
  new_path,
  max_batch = fs_bytes("100MB"),
  overwrite = FALSE,
  ...
)

s3_dir_upload(path, new_path, max_batch, overwrite = FALSE, ...)
}
\arguments{
\item{path}{(character): A character vector of local file paths to upload to AWS S3}

\item{new_path}{(character): A character vector of AWS S3 paths or uri's of the new locations.}

\item{max_batch}{(\link[fs]{fs_bytes}): Maximum batch size being uploaded with each multipart.}

\item{overwrite}{(logical): Overwrite files if the exist. If this is \code{FALSE}
and the file exists an error will be thrown.}

\item{...}{parameters to be passed to \code{\link[paws.storage]{s3_put_object}}
and \code{\link[paws.storage]{s3_create_multipart_upload}}}
}
\value{
character vector of s3 uri paths
}
\description{
\code{s3_file_upload} upload files to AWS S3

\code{s3_dir_upload} upload directory to AWS S3
}
