% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_system.R
\name{s3_file_move}
\alias{s3_file_move}
\title{Move or rename S3 files}
\usage{
s3_file_move(path, new_path, max_batch = 100 * MB, overwrite = FALSE, ...)
}
\arguments{
\item{path}{(character): A character vector of s3 uri}

\item{new_path}{(character): A character vector of s3 uri.}

\item{max_batch}{(numeric): Maximum batch size being uploaded with each multipart.}

\item{overwrite}{(logical): Overwrite files if the exist. If this is \code{FALSE}
and the file exists an error will be thrown.}

\item{...}{parameters to be passed to \code{\link[paws.storage]{s3_copy_object}}}
}
\value{
character vector of s3 uri paths
}
\description{
Move files to another location on AWS S3
}
\examples{
\dontrun{
# Require AWS S3 credentials

temp_file = s3_file_temp(tmp_dir= "MyBucket")
s3_file_create(temp_file)

s3_file_move(temp_file, "s3://MyBucket/new_file.txt")
}
}
