% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normcheck.R
\name{normcheck}
\alias{normcheck}
\alias{normcheck.default}
\alias{normcheck.lm}
\title{Testing for normality plot}
\usage{
normcheck(x, ...)

\method{normcheck}{default}(x, xlab = c("Theoretical Quantiles", ""),
  ylab = c("Sample Quantiles", ""), main = c("", ""), col = "light blue",
  shapiro.wilk = FALSE, ...)

\method{normcheck}{lm}(x, xlab = c("Theoretical Quantiles", ""),
  ylab = c("Sample Quantiles", ""), main = c("", ""), col = "light blue",
  shapiro.wilk = FALSE, ...)
}
\arguments{
\item{x}{the residuals from fitting a linear model.  Alternatively, a fitted \code{lm} object.}

\item{\dots}{additional arguments which are passed to both \code{qqnorm} and \code{hist}}

\item{xlab}{a title for the x-axis of both the Q-Q plot and the histogram: see \code{\link{title}}.}

\item{ylab}{a title for the y-axis of both the Q-Q plot and the histogram: see \code{\link{title}}.}

\item{main}{a title for both the Q-Q plot and the histogram: see \code{\link{title}}.}

\item{col}{a color for the bars of the histogram.}

\item{shapiro.wilk}{if \code{TRUE}, then in the top left hand corner of the
Q-Q plot, the P-value from the Shapiro-Wilk test for normality is displayed.}
}
\description{
Plots two plots side by side. Firstly it draws a Normal QQ-plot of the
residuals, along with a line which has an intercept at the mean of the
residuals and a slope equal to the standard deviation of the residuals. If
\code{shapiro.wilk = TRUE} then, in the top left hand corner of the Q-Q
plot, the P-value from the Shapiro-Wilk test for normality is given.
Secondly, it draws a histogram of the residuals. A normal distribution is
fitted and superimposed over the histogram. NOTE: if you want to leave the 
x-axis blank in the histogram then, use \code{xlab = c("Theoretical Quantiles", " ")}
, i.e. leave a space between the quotes. If you don't leave a space, then information 
will be extracted from \code{x}.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Testing for normality plot

\item \code{lm}: Testing for normality plot
}}

\examples{

# An exponential growth curve
e = rnorm(100, 0, 0.1)
x = rnorm(100)
y = exp(5 + 3 * x + e)
fit = lm(y ~ x)
normcheck(fit)

# An exponential growth curve with the correct transformation
fit = lm(log(y) ~ x)
normcheck(fit)

# Same example as above except we use normcheck.default
normcheck(residuals(fit))

# Peruvian Indians data
data(peru.df)
normcheck(lm(BP ~ weight, data = peru.df))

}
\seealso{
\code{\link{shapiro.test}}.
}
\keyword{hplot}
