% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeplot.param.R
\name{makeplot.param}
\alias{makeplot.param}
\title{Plotting parameters}
\usage{
makeplot.param(chains, burnin = 0, parameter = "LnL", facet = TRUE,
  free_y = FALSE)
}
\arguments{
\item{chains}{A set of rwty.trees objects.}

\item{burnin}{The number of trees to omit as burnin.}

\item{parameter}{The column name of the parameter to plot.}

\item{facet}{Boolean denoting whether to make a facet plot.}

\item{free_y}{TRUE/FALSE to turn free y scales on the facetted plots on or off (default FALSE). Only works if facet = TRUE.}
}
\value{
param.plot Returns a ggplot object.
}
\description{
Plots parameter values over the length of the MCMC chain
}
\examples{
data(fungus)
makeplot.param(fungus, burnin=20, parameter="pi.A.")
}
\keyword{convergence,}
\keyword{mcmc,}
\keyword{parameter,}
\keyword{phylogenetics}
\keyword{plot,}

