% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infer_deps.R
\name{infer_deps}
\alias{infer_deps}
\title{Infer dependencies}
\usage{
infer_deps(
  path = here::here(),
  which = c("Imports", "Suggests"),
  imports_thresh = 2,
  imports = NULL,
  suggests = c("testthat", "rmarkdown", "markdown", "knitr", "remotes", "knitr", "covr"),
  errors = c("reported", "fatal", "ignored"),
  dev = FALSE,
  progress = TRUE,
  add_newlines = FALSE
)
}
\arguments{
\item{path}{The path to a (possibly multi-mode) \R file, or a directory
containing such files. By default, all files within the current working
directory are checked, recursively.}

\item{which}{Which types of dependencies to return.}

\item{imports_thresh}{The minimum number of times that a package has to be 
called within your package to assign it as an Import.
 If is called less times than this threshold, 
 it will instead be assigned as a Suggest, 
 which means it will not be installed by default.}

\item{imports}{R packages that are exempt from the \code{suggests_thresh}
rule and are instead automatically assigned as Imports.}

\item{suggests}{R packages that are exempt from the \code{suggests_thresh}
rule and are instead automatically assigned as Suggests.}

\item{errors}{How should errors that occur during dependency enumeration be
handled? See \strong{Errors} for more details.}

\item{dev}{Boolean; include 'development' dependencies as well? That is,
packages which may be required during development but are unlikely to be
required during runtime for your project. By default, only runtime
dependencies are returned.}

\item{progress}{Boolean; report progress output while enumerating
dependencies?}

\item{add_newlines}{Prefix each package name with a newline character 
and two spaces. This is useful for formatting \emph{DESCRIPTION} files.}
}
\value{
A character vector of R package names.
}
\description{
Infers the R packages that your R package depends on.
}
\examples{
deps <- infer_deps()
}
