% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoencoder.R, R/generics.R
\name{train.ruta_autoencoder}
\alias{train.ruta_autoencoder}
\alias{train}
\title{Train a learner object with data}
\usage{
\method{train}{ruta_autoencoder}(learner, data, validation_data = NULL,
  metrics = NULL, epochs = 20,
  optimizer = keras::optimizer_rmsprop(), ...)

train(learner, ...)
}
\arguments{
\item{learner}{A \code{"ruta_autoencoder"} object}

\item{data}{Training data: columns are attributes and rows are instances}

\item{validation_data}{Additional numeric data matrix which will not be used
for training but the loss measure and any metrics will be computed against it}

\item{metrics}{Optional list of metrics which will evaluate the model but
won't be optimized. See \code{keras::\link[keras]{compile}}}

\item{epochs}{The number of times data will pass through the network}

\item{optimizer}{The optimizer to be used in order to train the model, can
be any optimizer object defined by Keras (e.g. \code{keras::optimizer_adam()})}

\item{...}{Additional parameters for \code{keras::\link[keras]{fit}}. Some useful parameters:
\itemize{
\item \code{batch_size} The number of examples to be grouped for each gradient update.
Use a smaller batch size for more frequent weight updates or a larger one for
faster optimization.
\item \code{shuffle} Whether to shuffle the training data before each epoch, defaults to \code{TRUE}
}}
}
\value{
Same autoencoder passed as parameter, with trained internal models
}
\description{
This function compiles the neural network described by the learner object
and trains it with the input data.
}
\examples{
# Minimal example ================================================
\donttest{
iris_model <- train(autoencoder(2), as.matrix(iris[, 1:4]))
}

# Simple example with MNIST ======================================
\donttest{
library(keras)

# Load and normalize MNIST
mnist = dataset_mnist()
x_train <- array_reshape(
  mnist$train$x, c(dim(mnist$train$x)[1], 784)
)
x_train <- x_train / 255.0
x_test <- array_reshape(
  mnist$test$x, c(dim(mnist$test$x)[1], 784)
)
x_test <- x_test / 255.0

# Autoencoder with layers: 784-256-36-256-784
learner <- autoencoder(c(256, 36), "binary_crossentropy")
train(
  learner,
  x_train,
  epochs = 1,
  optimizer = "rmsprop",
  batch_size = 64,
  validation_data = x_test,
  metrics = list("binary_accuracy")
)
}
}
\seealso{
\code{\link{autoencoder}}
}
