% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rate_limit.R
\name{rate_limit}
\alias{rate_limit}
\alias{rate_limit_reset}
\alias{rate_limit_wait}
\title{Rate limit helpers}
\usage{
rate_limit(resource_match = NULL, token = NULL)

rate_limit_reset(endpoint, token = NULL)

rate_limit_wait(endpoint, token = NULL)
}
\arguments{
\item{resource_match}{An optional regular expression used to filter the
resources listed in returned rate limit data.}

\item{token}{Expert use only. Use this to override authentication for
a single API call. In most cases you are better off changing the
default for all calls. See \code{\link[=auth_as]{auth_as()}} for details.}

\item{endpoint}{Name of Twitter endpoint like \code{"lookup/users"},
\code{"/media/upload"}, or \code{"/feedback/show/:id"}.}
}
\description{
\itemize{
\item \code{rate_limit()} returns a tibble of info about all rate limits
\item \code{rate_limit_reset()} returns the next reset for a endpoint
\item \code{rate_limit_wait()} waits for the next reset for an endpoint
}

You should not need to use these function in the usual operation of rtweet
because all paginated functions will wait on your behalf if you set
\code{retryonratelimit = TRUE}.
}
\examples{
if (auth_has_default()) {
rate_limit()
}
}
\references{
\url{https://developer.twitter.com/en/docs/twitter-api/v1/developer-utilities/rate-limit-status}
}
\seealso{
Other tokens: 
\code{\link{create_token}()},
\code{\link{get_token}()}
}
\concept{tokens}
