% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threeFACTORplot.r
\name{threeFACTORplot}
\alias{threeFACTORplot}
\title{Bar plot of the relative gene expression (RE) from the \code{qpcrANOVA} output of a a three-factorial experiment data}
\usage{
threeFACTORplot(
  res,
  arrangement = c(1, 2, 3),
  bar.width = 0.5,
  fill = "Reds",
  xlab = "none",
  ylab = "Relative Expression",
  errorbar = "se",
  y.axis.adjust = 0.5,
  y.axis.by = 2,
  letter.position.adjust = 0.3,
  legend.title = "Legend Title",
  legend.position = c(0.4, 0.8),
  fontsize = 12,
  fontsizePvalue = 7,
  show.letters = TRUE,
  axis.text.x.angle = 0,
  axis.text.x.hjust = 0.5
)
}
\arguments{
\item{res}{an object created by \code{qpcrANOVA(x)} function on a three factorial data such as \code{data_3factor} example data frame.}

\item{arrangement}{order based on the columns in the output table (e.g. c(2,3,1) or c(1,3,2)) affecting factor arrangement of the output graph.}

\item{bar.width}{a positive number determining bar width.}

\item{fill}{a color vector specifying the fill color for the columns of the bar plot. One of the palettes in \code{\link[RColorBrewer]{display.brewer.all}} (e.g. "Reds" or "Blues", ...) can be applied.}

\item{xlab}{the title of the x axis}

\item{ylab}{the title of the y axis}

\item{errorbar}{Type of error bar, can be \code{se} or \code{ci}.}

\item{y.axis.adjust}{a negative or positive number for reducing or increasing the length of the y axis.}

\item{y.axis.by}{determines y axis step length}

\item{letter.position.adjust}{adjust the distance between the grouping letters to the error bars}

\item{legend.title}{legend title}

\item{legend.position}{a two digit vector specifying the legend position.}

\item{fontsize}{all fonts size of the plot}

\item{fontsizePvalue}{font size of the pvalue labels}

\item{show.letters}{a logical variable. If TRUE, mean grouping letters are added to the bars.}

\item{axis.text.x.angle}{angle of x axis text}

\item{axis.text.x.hjust}{horizontal justification of x axis text}
}
\value{
Bar plot of the average fold change for target genes along with the significance and the 95\% confidence interval as error bars.
}
\description{
Bar plot of the relative expression (RE) of a gene along with the confidence interval and significance
}
\details{
The \code{threeFACTORplot} function generates the bar plot of the average fold change for target genes along with the significance, standard error (se) and the 95\% confidence interval (ci).
}
\examples{

#' # See a sample data frame
data_3factor

# Before plotting, the result needs to be extracted as below:
res <- qpcrANOVA(data_3factor, numberOfrefGenes = 1)
res

# Arrange the first three colunms of the result table.
# This determines the columns order and shapes the plot output.
threeFACTORplot(res,
    arrangement = c(3, 1, 2),
    xlab = "condition")



threeFACTORplot(res,
   arrangement = c(1, 2, 3),
   bar.width = 0.5,
   fill = "Greys",
   xlab = "Genotype",
   ylab = "Relative Expression")



# Reordering factor levels to a desired order.
res$Conc <- factor(res$Conc, levels = c("L","M","H"))
res$Type <- factor(res$Type, levels = c("S","R"))

# Producing the plot
threeFACTORplot(res,
   arrangement = c(2, 3, 1),
   bar.width = 0.5,
   fill = "Reds",
   xlab = "Drought",
   ylab = "Relative Expression",
   errorbar = "se",
   legend.title = "Genotype",
   legend.position = c(0.2, 0.8))


# When using ci as error, increase the 
# y.axis.adjust value to see the plot correctly!
threeFACTORplot(res,
   arrangement = c(2, 3, 1),
   bar.width = 0.8,
   fill = "Greens",
   xlab = "Drought",
   ylab = "Relative Expression",
   errorbar = "ci",
   y.axis.adjust = 8,
   y.axis.by = 2,
   letter.position.adjust = 0.6,
   legend.title = "Genotype",
   fontsize = 12,
   legend.position = c(0.2, 0.8),
   show.letters = TRUE)



}
\author{
Ghader Mirzaghaderi
}
