% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qpcrANCOVA.r
\name{qpcrANCOVA}
\alias{qpcrANCOVA}
\title{ANCOVA and ANOVA on a factorial design plus bar plot of FC}
\usage{
qpcrANCOVA(
  x,
  numberOfrefGenes,
  block = NULL,
  analysisType = "ancova",
  main.factor,
  levels,
  level.names = "none",
  width = 0.5,
  fill = "skyblue",
  y.axis.adjust = 1,
  y.axis.by = 1,
  letter.position.adjust = 0.1,
  ylab = "Average Fold Change",
  xlab = "Pairs",
  fontsize = 12,
  p.adj = c("none", "holm", "hommel", "hochberg", "bonferroni", "BH", "BY", "fdr")
)
}
\arguments{
\item{x}{a data frame of condition (or conditions) levels, E (efficiency), genes and Ct values. Each Ct value in the data frame is the mean of technical replicates. Please refer to the vignette for preparing your data frame correctly.}

\item{numberOfrefGenes}{number of reference genes. Up to two reference genes can be handled.}

\item{block}{column name of the blocking factor (for correct column arrangement see example data.)}

\item{analysisType}{should be one of "ancova" or "anova".}

\item{main.factor}{main factor (not covariate) for which the levels FC is compared.}

\item{levels}{a numeric vector corresponding to the main factor levels. First number indicates Control level to which the other levels are compared.}

\item{level.names}{a vector determining level names in the x axis on the plot.}

\item{width}{a positive number determining bar width.}

\item{fill}{specify the fill color for the columns of the bar plot.}

\item{y.axis.adjust}{a negative or positive value for reducing or increasing the length of the y axis.}

\item{y.axis.by}{determines y axis step length}

\item{letter.position.adjust}{adjust the distance between the signs and the error bars.}

\item{ylab}{the title of the y axis}

\item{xlab}{the title of the x axis}

\item{fontsize}{all fonts size of the plot}

\item{p.adj}{method for adjusting p values (see \code{p.adjust})}
}
\value{
A list with 2 elements:
\describe{
  \item{Final_data}{}
  \item{lmf}{lm of factorial analysis-tyle}
  \item{lmc}{lm of ANCOVA analysis-type}
  \item{ANOVA_table}{ANOVA table}
  \item{ANCOVA_table}{ANCOVA table}
  \item{Table}{Table of FC values and significance and the 95 percent CI as error bars.}
  \item{plot}{Bar plot of the average fold change for the main factor levels.}
}
}
\description{
ANCOVA (analysis of covariance) and ANOVA (analysis of variance) can be performed using \code{qpcrANCOVA} function, if more than a factor exist. This works even if there is one factor in the experiment. Bar plot of fold changes (FCs) along with the 95\% confidence interval is also returned by the \code{qpcrANCOVA} function. There is also a function called \code{oneFACTORplot} which returns FC values and related plot for a one-factor-experiment with more than two levels.
}
\details{
The \code{qpcrANCOVA} function applies both ANCOVA and ANOVA analysis to the data. ANCOVA is a method based on both ANOVA and linear regression. It is basically suitable when the levels of a factor are also affected by an uncontrolled quantitative covariate. 
For example, suppose that wDCt of a target gene in a plant is affected by temperature. The gene may also be affected by drought. since we already know that temperature affects the target gene, we are interesting now if the gene expression is also altered by the drought levels. We can design an experiment to understand the gene behavior at both temperature and drought levels at the same time. The drought is another factor (the covariate) that may affect the expression of our gene under the levels of the first factor i.e. temperature. The data of such an experiment can be analyzed by ANCOVA or even ANOVA based on a factorial experiment using \code{qpcrANCOVA} function, if more than a factor exist. Bar plot of fold changes (FCs) along with the 95\% confidence interval is also returned by the \code{qpcrANCOVA} function. There is also a function called \code{oneFACTORplot} which returns FC values and related plot for a one-factor-experiment with more than two levels
}
\examples{

# See sample data
data_2factor


qpcrANCOVA(data_2factor, 
           numberOfrefGenes = 1, 
           analysisType = "ancova", 
           main.factor = 1,
           levels = c(1, 2))
           

qpcrANCOVA(data_2factorBlock, 
           numberOfrefGenes = 1,
           block = "block",  
           analysisType = "ancova", 
           main.factor = 2,
           levels = c(3, 2, 1))
           
           
 qpcrANCOVA(data_1factor, 
           numberOfrefGenes = 1,
           analysisType = "ancova", 
           main.factor = 1,
           levels = 3:1)
           
           

}
\author{
Ghader Mirzaghaderi
}
