% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cg_memberlist.R
\name{cg_memberslist}
\alias{cg_memberslist}
\title{Get a list of members of a particular chamber in a particular Congress}
\usage{
cg_memberslist(congress_no = NULL, chamber = NULL, state = NULL,
  district = NULL, key = NULL, ...)
}
\arguments{
\item{congress_no}{The number of the Congress during which the members served.}

\item{chamber}{One of 'house' or 'senate.}

\item{state}{Limits the list of members by state; two-letter state code (e.g., CA).}

\item{district}{Limits the list of members by district (House only). If you specify
a district, you must also specify a state. If the district number you
specify is higher than the total number of districts for that state,
a 404 response will be returned.}

\item{key}{your New York Times API key; pass in, or loads from .Rprofile as
\code{nytimes_cg_key}, or from .Renviron as \code{NYTIMES_CG_KEY}}

\item{...}{Curl options (debugging tools mostly) passed to \code{\link[httr]{GET}}}
}
\value{
List of members of a particular chamber in a particular Congress.
}
\description{
Get a list of members of a particular chamber in a particular Congress
}
\examples{
\dontrun{
cg_memberslist(112, 'senate', "TX")
cg_memberslist(112, 'senate', 'NH')
cg_memberslist(110, 'senate', 'NH')
}
}

