% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/as.FlexTable.ftable.R
\name{as.FlexTable.ftable}
\alias{as.FlexTable.ftable}
\title{get FlexTable from a ftable object}
\usage{
\method{as.FlexTable}{ftable}(x, text.properties = textNormal(),
  padding.left = 4, padding.right = 4, ...)
}
\arguments{
\item{x}{object to get \code{FlexTable} from}

\item{text.properties}{default text formatting properties}

\item{padding.left}{cells paragraphs left padding - 0 or positive integer value.}

\item{padding.right}{cells paragraphs right padding - 0 or positive integer value.}

\item{...}{further arguments, not used.}
}
\value{
a \code{\link{FlexTable}} object
}
\description{
Get a \code{\link{FlexTable}} object from
a \code{\link{ftable}} object.
}
\examples{
#
# ftable example 1 -------------
mtcars_ftable = ftable(mtcars$cyl, mtcars$vs, mtcars$am, mtcars$gear, 
	row.vars = c(2, 4),
	dnn = c("Cylinders", "V/S", "Transmission", "Gears"))

FT = as.FlexTable( x = mtcars_ftable, caption = pot("This is a caption", 
	textBold(color="blue") ) ) 
print( FT )
if( interactive() ) readline("Hit <Return> to see next FlexTable:")


# ftable example 2 -------------
FT = as.FlexTable( x = ftable(Titanic, row.vars = 1:3) )
print( FT )
if( interactive() ) readline("Hit <Return> to see next FlexTable:")

FT = as.FlexTable( x = ftable(Titanic, row.vars = 1:2, col.vars = "Survived") )
print( FT )
if( interactive() ) readline("Hit <Return> to see next FlexTable:")

FT = as.FlexTable( x = ftable(Titanic, row.vars = 2:1, col.vars = "Survived") )
print( FT )


}

