% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readOnly.R
\name{readOnly}
\alias{readOnly}
\alias{readOnly,character-method}
\alias{readOnly,SsimLibrary-method}
\alias{readOnly,Project-method}
\alias{readOnly,Scenario-method}
\alias{readOnly,Folder-method}
\alias{readOnly,Chart-method}
\alias{readOnly<-}
\alias{readOnly<-,character-method}
\alias{readOnly<-,SsimObject-method}
\alias{readOnly<-,Folder-method}
\alias{readOnly<-,Chart-method}
\title{Read-only status of a SsimLibrary, Project, Scenario, Folder or Chart}
\usage{
readOnly(ssimObject)

\S4method{readOnly}{character}(ssimObject)

\S4method{readOnly}{SsimLibrary}(ssimObject)

\S4method{readOnly}{Project}(ssimObject)

\S4method{readOnly}{Scenario}(ssimObject)

\S4method{readOnly}{Folder}(ssimObject)

\S4method{readOnly}{Chart}(ssimObject)

readOnly(ssimObject) <- value

\S4method{readOnly}{character}(ssimObject) <- value

\S4method{readOnly}{SsimObject}(ssimObject) <- value

\S4method{readOnly}{Folder}(ssimObject) <- value

\S4method{readOnly}{Chart}(ssimObject) <- value
}
\arguments{
\item{ssimObject}{\code{\link{Scenario}}, \code{\link{Project}},
\code{\link{SsimLibrary}}, or \code{\link{Folder}} object}

\item{value}{logical. If \code{TRUE} the SsimObject will be read-only. Default is
\code{FALSE}}
}
\value{
A logical: \code{TRUE} if the SsimObject is read-only and \code{FALSE}
otherwise.
}
\description{
Retrieves or sets whether or not a \code{\link{SsimLibrary}},
\code{\link{Project}}, \code{\link{Scenario}}, \code{\link{Folder}},
or \code{\link{Chart}} is read-only.
}
\examples{
\dontrun{
# Specify file path and name of new SsimLibrary
myLibraryName <- file.path(tempdir(), "testlib")

# Set up a SyncroSim Session, SsimLibrary, Project, Scenario, and Folder
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName, session = mySession)
myProject <- project(myLibrary, project = "Definitions")
myScenario <- scenario(myProject, scenario = "My Scenario")
myFolder <- folder(myProject, "My Folder")

# Retrieve the read-only status of a SsimObject
readOnly(myLibrary)
readOnly(myProject)
readOnly(myScenario)
readOnly(myFolder)

# Set the read-only status of a SsimObject
readOnly(myScenario) <- TRUE
}

}
