% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parentId.R
\name{parentId}
\alias{parentId}
\alias{parentId,character-method}
\alias{parentId,Scenario-method}
\alias{parentId,Folder-method}
\title{Retrieves the parent Scenario id or parent Folder id}
\usage{
parentId(child)

\S4method{parentId}{character}(child)

\S4method{parentId}{Scenario}(child)

\S4method{parentId}{Folder}(child)
}
\arguments{
\item{child}{\code{\link{Scenario}} or \code{\link{Folder}} object}
}
\value{
An integer id of the parent Scenario if input is a Scenario, or an integer
id of the parent Folder if input is a Folder. If the input Scenario or Folder
does not have a parent, the function returns \code{NA}
}
\description{
Retrieves the id of the parent of a SyncroSim results Scenario or a SyncroSim
Folder.
}
\examples{
\dontrun{
# Set the file path and name of an existing SsimLibrary
myLibraryName <- "MyLibrary.ssim"

# Set the SyncroSim Session, SsimLibrary, Project, and Scenario
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName,
                         session = mySession)
myProject <- project(myLibrary, project = "Definitions")
myScenario <- scenario(myProject, scenario = "My Scenario")

# Run Scenario to generate results
resultScenario <- run(myScenario)

# Find the parent ID of the Scenario
parentId(resultScenario)
}

}
