% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parentId.R
\name{parentId}
\alias{parentId}
\alias{parentId,character-method}
\alias{parentId,Scenario-method}
\title{Retrieves the parent Scenario id}
\usage{
parentId(scenario)

\S4method{parentId}{character}(scenario)

\S4method{parentId}{Scenario}(scenario)
}
\arguments{
\item{scenario}{\code{\link{Scenario}} object}
}
\value{
An integer id of the parent Scenario. If the input Scenario does not have a
parent, the function returns \code{NA}
}
\description{
Retrieves the id of the parent of a SyncroSim results Scenario.
}
\examples{
\donttest{
# Install helloworldSpatial SyncroSim package
addPackage("helloworldSpatial")

# Set the file path and name of the new SsimLibrary
myLibraryName <- file.path(tempdir(),"testlib_parentId")

# Set the SyncroSim Session, SsimLibrary, Project, and Scenario
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName,
                         session = mySession,
                         package = "helloworldSpatial",
                         template = "example-library")
myProject <- project(myLibrary, project = "Definitions")
myScenario <- scenario(myProject, scenario = "My Scenario")

# Run Scenario to generate results
resultScenario <- run(myScenario)

# Find the parent ID of the Scenario
parentId(resultScenario)
}

}
