/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.search;

import java.util.ArrayList;
import java.util.List;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.subgroup.KBestSGSet;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGDescription;
import org.vikamine.kernel.subgroup.SGSet;
import org.vikamine.kernel.subgroup.SGSets;
import org.vikamine.kernel.subgroup.SGStatisticsBinary;
import org.vikamine.kernel.subgroup.search.SDMethod;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.subgroup.target.SGTarget;

public class SDBeamSearch
extends SDMethod {
    private static final String NAME = "SDBEAMSearch";
    protected boolean hasImproved = false;
    private int initialSubgroupDescriptionLength = 0;
    private List<SGSet> iterationSubgroupResults;

    private void expandBeamUsingAttribute(SG sg, Attribute attr, KBestSGSet resultSGSet) {
        for (SGSelector sel : this.task.searchSpace) {
            SG currentSG;
            SGDescription currentSGD;
            if (!sel.getAttribute().equals(attr) || !this.addSGSelector(currentSGD = (currentSG = (SG)sg.clone()).getSGDescription(), sel) || resultSGSet.contains(currentSG)) continue;
            currentSG.createStatistics(this.getOptions());
            currentSG.updateQuality(this.task.getQualityFunction());
            if (!this.doAddSubgroup(resultSGSet, currentSG)) continue;
            this.addSGToSGSet(resultSGSet, currentSG);
            this.hasImproved = true;
        }
    }

    protected boolean addSGSelector(SGDescription sgd, SGSelector sel) {
        if (!sgd.contains(sel)) {
            sgd.add(sel);
            return true;
        }
        return false;
    }

    private KBestSGSet beam(KBestSGSet currentSGSet, SGTarget target) {
        this.hasImproved = false;
        KBestSGSet resultSGSet = (KBestSGSet)SGSets.copySGSet(currentSGSet);
        for (SG sg : currentSGSet) {
            SGDescription sgd = sg.getSGDescription();
            if (this.isAborted()) {
                return resultSGSet;
            }
            if (sgd.size() - this.initialSubgroupDescriptionLength >= this.task.getMaxSGDSize()) break;
            for (Attribute attr : this.task.getAttributes()) {
                if (!this.isValidAttribute(attr, target, sgd)) continue;
                this.expandBeamUsingAttribute(sg, attr, resultSGSet);
            }
        }
        return resultSGSet;
    }

    private void addSGToSGSet(KBestSGSet resultSGSet, SG currentSG) {
        resultSGSet.addByReplacingWorstSG(currentSG);
        if (this.task.isSuppressStrictlyIrrelevantSubgroups()) {
            SGSets.removeIrrelevantSubgroupsFromSGSet(resultSGSet);
        }
    }

    private boolean fulfillsMinSupport(SG currentSG) {
        if (currentSG.getTarget().isBoolean()) {
            SGStatisticsBinary statistics = (SGStatisticsBinary)currentSG.getStatistics();
            return this.fullfillsMinSupportBooleanTarget(statistics.getTp(), currentSG.getStatistics().getSubgroupSize());
        }
        return this.fullfillsMinSupportNumericTarget(currentSG.getStatistics().getSubgroupSize());
    }

    protected boolean doAddSubgroup(KBestSGSet sgSet, SG currentSG) {
        return this.fulfillsMinSupport(currentSG) && sgSet.isInKBestQualityRange(currentSG.getQuality()) && !sgSet.contains(currentSG) && (!this.task.isSuppressStrictlyIrrelevantSubgroups() || !SGSets.isSGStrictlyIrrelevant(currentSG, sgSet));
    }

    protected boolean isValidAttribute(Attribute attr, SGTarget target, SGDescription sgd) {
        return !sgd.containsAttributeAsSelector(attr) && !target.getAttributes().contains(attr) && (this.task.getAttributes() == null || this.task.getAttributes().contains(attr));
    }

    protected void searchInternal(SG initialSubgroup) {
        this.iterationSubgroupResults = new ArrayList<SGSet>();
        KBestSGSet currentSGSet = SGSets.createKBestSGSet(this.task.getMaxSGCount(), this.task.getMinQualityLimit());
        double initQual = this.task.getQualityFunction().evaluate(initialSubgroup);
        SG clonedInitial = (SG)initialSubgroup.clone();
        clonedInitial.setQuality(initQual);
        currentSGSet.add(clonedInitial);
        this.initialSubgroupDescriptionLength = initialSubgroup.getSGDescription().size();
        int iteration = 1;
        do {
            this.hasImproved = false;
            KBestSGSet resultSGSet = this.beam(currentSGSet, initialSubgroup.getTarget());
            if (!this.hasImproved) continue;
            resultSGSet.setName(String.valueOf(this.getName()) + " i" + iteration);
            this.iterationSubgroupResults.add(resultSGSet);
            currentSGSet = resultSGSet;
            ++iteration;
        } while (this.hasImproved);
        KBestSGSet allIterationResultsSGSet = SGSets.createKBestSGSet(Integer.MAX_VALUE, this.task.getMinQualityLimit());
        for (SGSet sgSet : this.iterationSubgroupResults) {
            for (SG sg : sgSet) {
                if (allIterationResultsSGSet.contains(sg)) continue;
                allIterationResultsSGSet.add(sg);
            }
        }
        allIterationResultsSGSet.setName(String.valueOf(this.getName()) + " All");
        this.iterationSubgroupResults.add(0, allIterationResultsSGSet);
    }

    @Override
    protected SGSet search(SG initialSubgroup) {
        this.searchInternal(initialSubgroup);
        return SGSets.mergeSGSetsToKBestSGSet(this.iterationSubgroupResults, this.task.getMaxSGCount(), this.task.getMinQualityLimit());
    }

    public List<SGSet> getIterationResults() {
        if (this.iterationSubgroupResults == null) {
            throw new IllegalStateException("Must perform subgroup search, before using Iteration results");
        }
        return this.iterationSubgroupResults;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isTreatMissingAsUndefinedSupported() {
        return true;
    }
}

