/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.examples;

import java.io.File;
import java.io.IOException;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.creators.DataFactory;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGDescription;
import org.vikamine.kernel.subgroup.SGStatisticsNumeric;
import org.vikamine.kernel.subgroup.quality.functions.StandardQF;
import org.vikamine.kernel.subgroup.selectors.DefaultSGSelector;
import org.vikamine.kernel.subgroup.target.SelectorTarget;

public class EvaluateSubgroupExample {
    public static void main(String[] args) throws IOException {
        Ontology onto = DataFactory.createOntology(new File("../org.vikamine.kernel.test/resources/datasets/adults.arff"));
        SelectorTarget target = new SelectorTarget(new DefaultSGSelector(onto, "class", ">50K"));
        SGDescription sgd = new SGDescription();
        sgd.add(new DefaultSGSelector(onto, "marital-status", "Married-civ-spouse"));
        sgd.add(new DefaultSGSelector(onto, "native-country", "United-States"));
        SG sg = new SG(onto.getDataView(), target, sgd);
        sg.createStatistics();
        System.out.println("Instances: " + sg.getStatistics().getSubgroupSize() + " out of " + sg.getStatistics().getDefinedPopulationCount());
        SGStatisticsNumeric numericStatististics = (SGStatisticsNumeric)sg.getStatistics();
        System.out.println("Maximum value of target in subgroup: " + numericStatististics.getMaxValueSG());
        System.out.println("Mean in subgroup: " + numericStatististics.getSGMean());
        System.out.println("Median in subgroup: " + numericStatististics.getSGMedian());
        System.out.println("Minimum value of target in subgroup: " + numericStatististics.getMinValueSG());
        System.out.println("");
        StandardQF qf = new StandardQF(0.5);
        System.out.println("Interestingness: " + qf.evaluate(sg));
    }
}

