% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{p_model_validation_vcmax25}
\alias{p_model_validation_vcmax25}
\title{SOFUN p-model Vcmax25 validation data}
\format{
A tibble of validation data:
\describe{
  \item{sitename}{A character string containing the site names (e.g. 'Reichetal_Colorado').}
  \item{data}{A tibble [ 1 x 2 ] with observations for the following variables:
    \describe{
      \item{vcmax25}{The observed maximum rate of carboxylation (Vcmax), normalised 
    to 25\eqn{^o} C (in mol C m\eqn{^{-2}} d\eqn{^{-1}}), aggregated over different plant species
    in each site.}
      \item{vcmax25_unc}{The uncertainty of the Vcmax25 (in mol C m\eqn{^{-2}} d\eqn{^{-1}}),
      calculated as the standard deviation among Vcmax25 observations for
      several species per site or as the total standard deviation across sites for
      single-plant-species sites.}
    }
  }
}
}
\source{
Atkin, O. K., Bloomfield, K. J., Reich, P. B., Tjoelker, M. G., Asner, G. P., Bonal, D., et al. (2015). 
Global variability in leaf respiration in relation to climate, plant functional types and leaf traits. 
New Phytol. 206 (2), 614–636. doi:10.1111/nph.13253
}
\usage{
p_model_validation_vcmax25
}
\description{
Small tests dataset to validate 
calibration routines for leaf traits.
}
\examples{
require(ggplot2); require(tidyr)
p_model_validation_vcmax25 \%>\% tidyr::unnest(data) 

}
\keyword{datasets}
