% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sed_insert.R
\name{sed_insert}
\alias{sed_insert}
\title{Insert one or more lines}
\usage{
sed_insert(stream, after, insertion, warn = FALSE, ...)
}
\arguments{
\item{stream}{A character vector, each element typically (but not necessarily) containing the text
from a single line in a file, which can be generated via \code{\link{readLines}}.}

\item{after}{An integer or character string that designates where \code{insertion} is added to \code{stream}.
If \code{after} is numeric, it designates the line (or element) number in \code{stream} after which the
\code{insertion} will be placed. The numeric value of \code{after} must be in \code{[0:length(stream)]}.
To make an insertion at the very beginning of \code{stream}, use \code{after = 0}.  If \code{after} is a
character string, the insertion is placed after the first element in \code{stream} that contains the string,
where matching is obtained using \code{\link{grep}}.}

\item{insertion}{A character vector that will be inserted into the stream after element \code{after}.
Each element in the vector would correspond to a separate line in the file.}

\item{warn}{If \code{TRUE}, warning messages are produced if insertion fails due to mispecifification
of \code{after}.}

\item{\dots}{Additional named arguments to \code{\link{grep}}, which are applicable if \code{after} is a character string.
In other words, \code{\link{grep}} is used to search for the first instance of \code{after}.}
}
\value{
The new \code{stream} with the insertions added. If the insertion fails because \code{after} is
specified incorrectly, \code{stream} is returned unchanged.
}
\description{
Insert one or more lines
}
\details{
\code{sed_insert} only accomodates a single insertion point.  Multiple lines may be inserted, but only one
insertion point is allowed, which is why \code{length(insertion)} must be 1.  To make insertions at multiple locations,
\code{sed_insert} can be called repeatedly on the same string as needed.
}
\examples{
################################################################################
# Let's create an example stream we can edit
################################################################################
stream <- c("Here's a line",
           "And another line",
           "Line after which we'll insert a string",
           "A line after which we'll insert another string",
           "A final line")
as.stream(stream)

# Insert a string using line numbers
stream <- sed_insert(stream, after = 3, "Here's the first insertion")
stream

# Insert a stream by searching for a string
stream <- sed_insert(stream,
                    c("Here's the second insertion",
                      "",
                      "Another line of the second insertion after the blank line"),
                    after = "insert another")
stream
}
\seealso{
\code{\link{sed_replace}}, \code{\link{sed_substitute}}, \code{\link{sed_comment}}, \code{\link{streamEdit}}
}
\author{
Landon Sego
}
\keyword{misc}
