% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accounts.R
\name{connectApiUser}
\alias{connectApiUser}
\title{Connect Api User Account}
\usage{
connectApiUser(account = NULL, server = NULL, apiKey = NULL, quiet = FALSE)
}
\arguments{
\item{account}{A name for the account to connect. Optional.}

\item{server}{The server to connect to. Optional if there is only one server
registered.}

\item{apiKey}{The API key used to authenticate the user}

\item{quiet}{Whether or not to show messages and prompts while connecting the
account.}
}
\description{
Connect a user account to the package using an API key for authentication
so that it can be used to deploy and manage
applications on behalf of the account.
}
\details{
This function configures the user to connect using an apiKey in
the http auth headers instead of a token. This is less secure but may
be necessary when the client is behind a proxy or otherwise unable to
authenticate using a token.
}
\seealso{
Other Account functions: 
\code{\link{accounts}()},
\code{\link{connectUser}()},
\code{\link{setAccountInfo}()}
}
\concept{Account functions}
