% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/percentTildePercent.R
\name{^.rscalaBridge}
\alias{^.rscalaBridge}
\title{Evaluation Operator Returning a Reference}
\usage{
\method{^}{rscalaBridge}(bridge, snippet)
}
\arguments{
\item{bridge}{An rscala bridge.}

\item{snippet}{String providing a Scala code snippet.}
}
\value{
Returns an rscala reference.
}
\description{
This operator is equivalent to \code{\link{*.rscalaBridge}}, except the
return value is always an rscala reference.
}
\examples{
\donttest{
scala(assign.name='e')              # Implicitly defines the bridge 'e'.
x <- e ^ 'new scala.util.Random()'  # These two lines ...
x <- e $ .new_scala.util.Random()   # ... are equivalent
e(rng=x) * 'rng.nextDouble()'
close(e)
}

}
\seealso{
\code{\link{*.rscalaBridge}}, \code{\link{+.rscalaBridge}},
  \code{\link{scala}}
}
