\name{fitsaemodel}
\alias{fitsaemodel}
\alias{print.fitsaemodel}
\alias{summary.fitsaemodel}
\alias{coef.fitsaemodel}

\title{
Fit SAE model using various methods
}
\description{
\code{fitsaemodel} is the workhorse function. It estimates SAE models that have been set up by \code{\link{saemodel}} (or synthetic data generated by \code{\link{makedata}}) by various (robust) estimation methods. 
}

\usage{
fitsaemodel(method, model, ...)

\method{print}{fitsaemodel}(x, digits=3, ...)
\method{summary}{fitsaemodel}(object, full=FALSE, digits=3, ...)
\method{coef}{fitsaemodel}(object, type="both", ...)
}

\arguments{
  \item{method}{
character string defining the method to be used; currently, either \code{method="ml"} for (non-robust) maximum likelihood or \code{method="huberm"} for Huber-type M-estimation
}
  \item{model}{
a \code{"saemodel"} object (i.e., a SAE model; see \code{\link{saemodel}})
}
  \item{x}{
used by the \code{print} method
}
  \item{digits}{
used by the \code{print} and \code{summary} methods; number of decimal places to be shown
}
  \item{object}{
an object of the class \code{"\link{fitsaemodel}"}; i.e., a fitted model
}
  \item{full}{
logical, if \code{full=TRUE}, the \code{summary} method shows all it has to show  (default: \code{full=FALSE})
}
  \item{type}{
character string use in the \code{coef} method; it can take one of the following possibilities: \code{"both"}, \code{"ranef"}, or \code{"fixef"}. The first reports both, random and fixed effects (default). 
}
  \item{\dots}{
additional arguments delivered to either \code{\link{fitsaemodel.control}}  
}
}
\details{
The function \code{fitsaemodel} is a wrapper function that calls the algorithm associated with a particular method. Two methods are currently implemented
\itemize{
   \item maximum likelihood (\code{method="ml"}),
   \item Huber-type M-estimation (\code{method="huberm"}).
}

\subsection{Maximum likelihood}{
The call for ML is straightforward: \code{fitsaemodel(method="ml", model)}, where \code{model} is a SAE model generated by \code{\link{saemodel}}. Note that ML is not a robust fitting method.

}

\subsection{Huber-type M-estimation}{
The call for Huber-type M-estimaton (with Huber psi-function) is: \code{fitsaemodel(method="huberm", model, k)}, where \code{model} is a SAE model generated by \code{\link{saemodel}}, and \code{k} is the robustness tuning constant of the Huber psi-function.

If your data are supposed to be heavily contaminated (\bold{or} if the \bold{default algorithm did not converge}), you may initialize the \code{fitsaemodel} alogrithm with a high-breakdown-point estimate. The \pkg{rsae} package offers two methods to initialize the algorithm, \code{"lts"} and \code{"s"}; see below. \bold{NOTE}, you have to install the \pkg{robustbase} package in order to use these methods. The initialization methods are called in the \code{fitsaemodel} device (as additional argument), using
 
   \itemize{
      \item \code{init="lts"}, for fast-LTS regression form \pkg{robustbase},
      \item \code{init="s"}, for a regression S-estimator from \pkg{robustbase}.
   }
For more details on the methods, you are refered to the documentation of \pkg{robustbase}. In general, for small to medium datasets, both methods are equivalent. For data with more than 50,000 observations, the S-estimator is considerably faster. (If the \code{"ml"} does not converge, you may initialize it analogously--though, it may be rather inefficient.)
}


}
\value{
An instance of the class \code{"fitmodel"}
}
\references{
Schoch, T. (2011) \emph{Robust Basic Unit-Level Small Area Model}, Working Paper
}
\author{
Tobias Schoch
} 
\seealso{
   \code{\link{fitsaemodel.control}}  
}

\examples{
#generate the synthetic data/model
mymodel <- makedata()
#compute Huber M-estimation type estimates of the model "mymodel"
#robustness tuning constant k = 2
myfittedmodel <- fitsaemodel("huberm", mymodel, k=2)
myfittedmodel
#get a summary of the model
summary(myfittedmodel)
}

