% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_publisher.R
\name{parse_publisher}
\alias{parse_publisher}
\title{Parse publisher list}
\usage{
parse_publisher(xml_source, outcome, hits)
}
\arguments{
\item{api_answer}{xml API answer}
}
\value{
Returns a data frame with the following columns:
\itemize{
\item \code{romeoid}     [\code{integer(1)}]\cr{}
the internal index of the publisher in the SHERPA/RoMEO
database
\item \code{publisher}   [\code{character(1)}]\cr{}
the name of the publisher
\item \code{alias}       [\code{character(1)}]\cr{}
if applicable an alternative name of the publisher or the
name of the specific publishing branch
\item \code{romeocolour} [\code{character(1)}]\cr{}
a colour assigned by the database that reflects the default
policies of the publisher
\item \code{preprint}    [\code{character(1)}]\cr{}
is the preprint (not reviewed) archivable?
\item \code{postprint}   [\code{character(1)}]\cr{}
is the postprint (reviewed but not formatted) archivable?
\item \code{pdf}         [\code{character(1)}]\cr{}
is the publisher's version (reviewed and formatted)
archivable?
}
}
\description{
When the returned content by the SHERPA/RoMEO API is a list of publishers
this function parses the list and returns a structured data.frame with
the default policies of the different publisher.
}
\keyword{internal}
