/*
 * Decompiled with CFR 0.152.
 */
package org.haldane.rrepast;

import java.io.File;
import java.util.Vector;
import java.util.logging.Logger;
import org.haldane.rrepast.ModelOutput;
import org.haldane.rrepast.ModelOutputFactory;
import org.haldane.rrepast.RepastEngineLogger;
import repast.simphony.batch.BatchScenarioLoader;
import repast.simphony.data2.DataSetManager;
import repast.simphony.engine.controller.DefaultController;
import repast.simphony.engine.environment.AbstractRunner;
import repast.simphony.engine.environment.ControllerRegistry;
import repast.simphony.engine.environment.DefaultRunEnvironmentBuilder;
import repast.simphony.engine.environment.RunEnvironment;
import repast.simphony.engine.environment.RunState;
import repast.simphony.engine.environment.Runner;
import repast.simphony.engine.schedule.ISchedule;
import repast.simphony.engine.schedule.Schedule;
import repast.simphony.parameter.ParameterSchema;
import repast.simphony.parameter.Parameters;
import repast.simphony.scenario.Scenario;
import repast.simphony.scenario.ScenarioLoadException;
import repast.simphony.scenario.data.ContextData;
import simphony.util.messages.MessageCenter;

public class RepastEngine
extends AbstractRunner {
    private static final Logger logger = RepastEngineLogger.getLogger();
    private static MessageCenter msgCenter = MessageCenter.getMessageCenter(RepastEngine.class);
    private ModelOutput output = ModelOutputFactory.getModelOutputStorage();
    private Scenario scenario;
    private DataSetManager manager;
    private Parameters parameters;
    private ISchedule schedule;
    private Number endAt = 0;
    private int runcount = 1;

    public RepastEngine() {
        System.setProperty("rrepast.modelinitializer", "org.haldane.rrepast.CustomInitializer");
        this.environmentBuilder = new DefaultRunEnvironmentBuilder((Runner)this, true);
        this.controller = new DefaultController(this.environmentBuilder);
        this.controller.setScheduleRunner((Runner)this);
        logger.info("RepastEngine instantiated successfully!");
    }

    public void ModelDataSet(String s) {
        this.output.setDataSet(s);
    }

    public void LoadModel(String s) {
        class MyBatchScenarioLoader
        extends BatchScenarioLoader {
            public MyBatchScenarioLoader(File scenarioDir) {
                super(scenarioDir);
            }

            public Scenario getMyScenario() {
                return this.scenario;
            }
        }
        MyBatchScenarioLoader loader;
        File file = new File(s);
        if (file.exists()) {
            loader = new MyBatchScenarioLoader(file);
            try {
                ControllerRegistry registry = loader.load(this.environmentBuilder);
                this.controller.setControllerRegistry(registry);
            }
            catch (ScenarioLoadException e) {
                e.printStackTrace();
            }
        } else {
            msgCenter.error((Object)"Scenario not found", (Throwable)new IllegalArgumentException("Invalid scenario " + file.getAbsolutePath()), new Object[0]);
            return;
        }
        this.parameters = loader.getParameters();
        this.controller.batchInitialize();
        this.controller.runParameterSetters(this.parameters);
        this.scenario = loader.getMyScenario();
        logger.info("Scenario loaded successfully");
    }

    public Scenario getScenario() {
        return this.scenario;
    }

    public DataSetManager getDataSetManager() {
        return this.manager;
    }

    public String[] getParameterNames() {
        Iterable names = this.parameters.getSchema().parameterNames();
        Vector<String> v = new Vector<String>();
        for (String n : names) {
            v.add(n);
        }
        return v.toArray(new String[v.size()]);
    }

    public Object getParameter(String s) {
        return this.parameters.getValue(s);
    }

    public String getParameterType(String k) {
        String s = "";
        ParameterSchema schema = null;
        schema = this.parameters.getSchema().getDetails(k);
        if (schema != null) {
            s = schema.getType().getName();
        }
        return s;
    }

    public String getParameterAsString(String s) {
        return this.parameters.getValueAsString(s);
    }

    public Number getParameterAsNumber(String s) {
        return (Number)this.parameters.getValue(s);
    }

    public double getParameterAsDouble(String s) {
        return ((Number)this.parameters.getValue(s)).doubleValue();
    }

    public boolean getParameterAsBoolean(String s) {
        return (Boolean)this.parameters.getValue(s);
    }

    public void setParameter(String s, String v) {
        this.parameters.setValue(s, (Object)v);
    }

    public void setParameter(String s, Number v) {
        this.parameters.setValue(s, (Object)v);
    }

    public void setParameter(String s, Double v) {
        this.parameters.setValue(s, (Object)v);
    }

    public void setParameter(String s, Integer v) {
        this.parameters.setValue(s, (Object)v);
    }

    public void setParameter(String s, Boolean v) {
        this.parameters.setValue(s, (Object)v);
    }

    public void endAt(double v) {
        this.endAt = v;
    }

    public void endAt(Number v) {
        this.endAt = v;
    }

    public Number endAt() {
        return this.endAt;
    }

    public String getId() {
        ContextData c;
        String id = "";
        if (this.scenario != null && (c = this.scenario.getContext()) != null) {
            id = c.getId();
        }
        return id;
    }

    public void execute(RunState arg0) {
    }

    public void batchInitialize() {
        this.controller.runInitialize(this.parameters);
        this.schedule = RunState.getInstance().getScheduleRegistry().getModelSchedule();
    }

    public void cleanUpRun() {
        this.controller.runCleanup();
    }

    public void cleanUpBatch() {
        this.controller.batchCleanup();
    }

    public int getModelActionCount() {
        return this.schedule.getModelActionCount();
    }

    public int getActionCount() {
        return this.schedule.getActionCount();
    }

    public void setFinishing(boolean b) {
        this.schedule.setFinishing(b);
    }

    public double getNextScheduledTime() {
        return ((Schedule)RunEnvironment.getInstance().getCurrentSchedule()).peekNextAction().getNextTime();
    }

    public void stop() {
        if (this.schedule != null) {
            this.schedule.executeEndActions();
        }
    }

    public void step() {
        this.schedule.execute();
    }

    public void RunModel() {
        if (this.runcount > 1) {
            ModelOutputFactory.getModelOutputStorage().softReset();
        }
        this.batchInitialize();
        while (this.getNextScheduledTime() < this.endAt().doubleValue()) {
            if (this.getActionCount() == 0 || this.getModelActionCount() == 0) {
                this.setFinishing(true);
            }
            this.step();
        }
        this.stop();
        this.cleanUpRun();
        ++this.runcount;
    }

    public String[] GetMockModelOutput() {
        Vector<String> rows = new Vector<String>();
        rows.add("run,random_seed,Time,Plasmid,R,D,T,G(R),G(D),G(T),gamma0(D),gamma0(T),Horizontal(D),Horizontal(T),R0(D),R0(T),(Experimental),(Simulated)");
        rows.add("1,12345,1,pABC,100,200,2,42,43,55,0.5,0.2,0.1,0.20,1,1,2,2");
        rows.add("1,12345,2,pABC,100,200,2,42,43,55,0.5,0.2,0.1,0.20,1,1,2,2");
        return rows.toArray(new String[rows.size()]);
    }

    public String[] GetModelOutput() {
        return this.output.getModelOutput();
    }
}

