% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rredlist-package.R
\docType{package}
\name{rredlist-package}
\alias{rredlist-package}
\alias{rredlist}
\title{rredlist: 'IUCN' Red List Client}
\description{
\if{html}{\figure{logo.png}{options: style='float: right' alt='logo' width='120'}}

'IUCN' Red List (\url{https://api.iucnredlist.org/}) client. The 'IUCN' Red List is a global list of threatened and endangered species. Functions cover all of the Red List 'API' routes. An 'API' key is required.
}
\section{Authentication}{

IUCN requires you to get your own API key, an alphanumeric string that you
need to send in every request. See \code{\link[=rl_use_iucn]{rl_use_iucn()}} for help getting and
storing it. Get it at \url{https://api.iucnredlist.org/users/sign_up}. Keep this
key private. You can pass the key in to each function via the \code{key}
parameter, but it's better to store the key either as an environment variable
(\code{IUCN_REDLIST_KEY}) or an R option (\code{iucn_redlist_key}) - we recommend using
the former option.
}

\section{High vs. Low level package APIs}{

\strong{High level API}
High level functions do the HTTP request and parse data to a data.frame for
ease of downstream use. The high level functions have no underscore on
the end of the function name, e.g., \code{\link[=rl_species]{rl_species()}}.

\strong{Low level API}
The parsing to data.frame in the high level API does take extra time.
The low level API only does the HTTP request, and gives back JSON without
doing any more parsing. The low level functions DO have an underscore on
the end of the function name, e.g., \code{\link[=rl_species_]{rl_species_()}}.
}

\section{No Spatial}{

This package does not include support for spatial data from the IUCN Red
List. IUCN Red List Spatial data can be downloaded at
\url{https://www.iucnredlist.org/resources/spatial-data-download}.
}

\section{Citing the IUCN Red List API}{

Get the proper citation for the version of the Red List you are using
by programatically running \code{\link[=rl_citation]{rl_citation()}}. Also see
\url{https://api.iucnredlist.org/}.
}

\section{Red List API Terms of Use}{

See \url{https://www.iucnredlist.org/terms/terms-of-use}.
}

\section{Rate limiting}{

From the IUCN folks: Too many frequent calls, or too many calls per day
might get your access blocked temporarily. If you're a heavy API user, the
Red List Unit asked that you contact them, as there might be better options.
They suggest a 2-second delay between your calls if you plan to make a
lot of calls.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://docs.ropensci.org/rredlist/}
  \item \url{https://github.com/ropensci/rredlist}
  \item Report bugs at \url{https://github.com/ropensci/rredlist/issues}
}

}
\author{
\strong{Maintainer}: William Gearty \email{willgearty@gmail.com}

Authors:
\itemize{
  \item Scott Chamberlain \email{myrmecocystus@gmail.com}
}

Other contributors:
\itemize{
  \item rOpenSci (\href{https://ror.org/019jywm96}{ROR}) [funder]
  \item Maëlle Salmon \email{maelle.salmon@yahoo.se} [contributor]
  \item Kevin Cazelles \email{kevin.cazelles@insileco.io} (\href{https://orcid.org/0000-0001-6619-9874}{ORCID}) [reviewer]
  \item Stephanie Hazlitt \email{stephhazlitt@gmail.com} [reviewer]
}

}
\keyword{internal}
\keyword{package}
