/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.lang.rdql;

import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.sparql.lang.rdql.ExprBoolean;
import com.hp.hpl.jena.sparql.lang.rdql.ExprNodeRDQL;
import com.hp.hpl.jena.sparql.lang.rdql.ExprRDQL;
import com.hp.hpl.jena.sparql.lang.rdql.NodeValueSettable;
import com.hp.hpl.jena.sparql.lang.rdql.RDQLEvalTypeException;
import com.hp.hpl.jena.sparql.lang.rdql.RDQLParser;
import com.hp.hpl.jena.sparql.lang.rdql.RDQLQueryPrintUtils;
import com.hp.hpl.jena.sparql.lang.rdql.RDQL_NodeValue;
import com.hp.hpl.jena.sparql.lang.rdql.WorkingVar;
import org.openjena.atlas.io.IndentedWriter;

public class Q_LogicalOr
extends ExprNodeRDQL
implements ExprRDQL,
ExprBoolean {
    ExprRDQL left;
    ExprRDQL right;
    private String printName = "or";
    private String opSymbol = "||";

    Q_LogicalOr(int id) {
        super(id);
    }

    Q_LogicalOr(RDQLParser p, int id) {
        super(p, id);
    }

    public RDQL_NodeValue evalRDQL(Query q, IndexValues env) {
        RDQL_NodeValue x = this.left.evalRDQL(q, env);
        RDQL_NodeValue y = this.right.evalRDQL(q, env);
        if (!x.isBoolean()) {
            throw new RDQLEvalTypeException("Q_LogicalOr: Wanted a boolean: " + x);
        }
        if (!y.isBoolean()) {
            throw new RDQLEvalTypeException("Q_LogicalOr: Wanted a boolean: " + y);
        }
        NodeValueSettable result = x instanceof NodeValueSettable ? (NodeValueSettable)x : (y instanceof NodeValueSettable ? (NodeValueSettable)y : new WorkingVar());
        boolean b = x.getBoolean() || y.getBoolean();
        result.setBoolean(b);
        return result;
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        if (n != 2) {
            throw new QueryException("Q_LogicalOr: Wrong number of children: " + n);
        }
        this.left = (ExprRDQL)((Object)this.jjtGetChild(0));
        this.right = (ExprRDQL)((Object)this.jjtGetChild(1));
    }

    public boolean isApply() {
        return true;
    }

    public String getFun() {
        return super.constructURI(this.getClass().getName());
    }

    public int argCount() {
        return 2;
    }

    public Expression getArg(int i) {
        if (i == 0 && this.left instanceof Expression) {
            return (Expression)this.left;
        }
        if (i == 1 && this.right instanceof Expression) {
            return (Expression)this.right;
        }
        return null;
    }

    public String asInfixString() {
        return RDQLQueryPrintUtils.asInfixString2(this.left, this.right, this.printName, this.opSymbol);
    }

    public String asPrefixString() {
        return RDQLQueryPrintUtils.asPrefixString(this.left, this.right, this.printName, this.opSymbol);
    }

    public void format(IndentedWriter w) {
        RDQLQueryPrintUtils.format(w, this.left, this.right, this.printName, this.opSymbol);
    }

    public String toString() {
        return this.asInfixString();
    }
}

