/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterConvert;
import java.util.Iterator;
import org.openjena.atlas.logging.Log;

public class QueryIterCommonParent
extends QueryIterConvert {
    public QueryIterCommonParent(QueryIterator input, Binding binding, ExecutionContext execCxt) {
        super(input, new ConverterExtend(binding), execCxt);
    }

    static class ConverterExtend
    implements QueryIterConvert.Converter {
        private Binding parentBinding;

        ConverterExtend(Binding parent) {
            this.parentBinding = parent;
        }

        public Binding convert(Binding b) {
            if (this.parentBinding == null || this.parentBinding.isEmpty()) {
                return b;
            }
            BindingMap b2 = new BindingMap(this.parentBinding);
            Iterator<Var> iter = b.vars();
            while (iter.hasNext()) {
                Var v = iter.next();
                Node n = b.get(v);
                if (b2.contains(v)) {
                    Node n2 = b2.get(v);
                    if (n2.equals((Object)n)) {
                        Log.warn(this, "Binding already for " + (Object)((Object)v) + " (same value)");
                    } else {
                        Log.fatal(this, "Binding already for " + (Object)((Object)v) + " (different values)");
                        throw new ARQInternalErrorException("QueryIteratorResultSet: Incompatible bindings for " + (Object)((Object)v));
                    }
                }
                b2.add(v, n);
            }
            return b2;
        }
    }
}

