/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.optimize;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVars;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpSequence;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.util.VarUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformFilterPlacement
extends TransformCopy {
    static boolean doFilterPlacement = true;

    public static Op transform(ExprList exprs, BasicPattern bgp) {
        if (!doFilterPlacement) {
            return OpFilter.filter(exprs, (Op)new OpBGP(bgp));
        }
        Op op = TransformFilterPlacement.transformFilterBGP(exprs, new HashSet<Var>(), bgp);
        op = TransformFilterPlacement.buildFilter(exprs, op);
        return op;
    }

    public static Op transform(ExprList exprs, Node graphNode, BasicPattern bgp) {
        if (!doFilterPlacement) {
            return OpFilter.filter(exprs, (Op)new OpQuadPattern(graphNode, bgp));
        }
        Op op = TransformFilterPlacement.transformFilterQuadPattern(exprs, new HashSet<Var>(), graphNode, bgp);
        op = TransformFilterPlacement.buildFilter(exprs, op);
        return op;
    }

    @Override
    public Op transform(OpFilter opFilter, Op x) {
        HashSet<Var> varsScope;
        if (!doFilterPlacement) {
            return super.transform(opFilter, x);
        }
        ExprList exprs = new ExprList(opFilter.getExprs());
        Op op = TransformFilterPlacement.transform(exprs, varsScope = new HashSet<Var>(), x);
        if (op == x) {
            return super.transform(opFilter, x);
        }
        op = TransformFilterPlacement.buildFilter(exprs, op);
        return op;
    }

    private static Op transform(ExprList exprs, Set<Var> varsScope, Op x) {
        if (x instanceof OpBGP) {
            return TransformFilterPlacement.transformFilterBGP(exprs, varsScope, (OpBGP)x);
        }
        if (x instanceof OpSequence) {
            return TransformFilterPlacement.transformFilterSequence(exprs, varsScope, (OpSequence)x);
        }
        if (x instanceof OpQuadPattern) {
            return TransformFilterPlacement.transformFilterQuadPattern(exprs, varsScope, (OpQuadPattern)x);
        }
        OpVars.patternVars(x, varsScope);
        return x;
    }

    private static Op transformFilterBGP(ExprList exprs, Set<Var> patternVarsScope, OpBGP x) {
        return TransformFilterPlacement.transformFilterBGP(exprs, patternVarsScope, x.getPattern());
    }

    private static Op transformFilterBGP(ExprList exprs, Set<Var> patternVarsScope, BasicPattern pattern) {
        Op op = TransformFilterPlacement.insertAnyFilter(exprs, patternVarsScope, null);
        for (Triple triple : pattern) {
            OpBGP opBGP = TransformFilterPlacement.getBGP(op);
            if (opBGP == null) {
                opBGP = new OpBGP();
                op = OpSequence.create(op, opBGP);
            }
            opBGP.getPattern().add(triple);
            VarUtils.addVarsFromTriple(patternVarsScope, triple);
            op = TransformFilterPlacement.insertAnyFilter(exprs, patternVarsScope, op);
        }
        return op;
    }

    private static OpBGP getBGP(Op op) {
        Op opTop;
        OpSequence opSeq;
        List<Op> x;
        if (op instanceof OpBGP) {
            return (OpBGP)op;
        }
        if (op instanceof OpSequence && (x = (opSeq = (OpSequence)op).getElements()).size() > 0 && (opTop = x.get(x.size() - 1)) instanceof OpBGP) {
            return (OpBGP)opTop;
        }
        return null;
    }

    private static Op transformFilterQuadPattern(ExprList exprs, Set<Var> patternVarsScope, OpQuadPattern pattern) {
        return TransformFilterPlacement.transformFilterQuadPattern(exprs, patternVarsScope, pattern.getGraphNode(), pattern.getBasicPattern());
    }

    private static Op transformFilterQuadPattern(ExprList exprs, Set<Var> patternVarsScope, Node graphNode, BasicPattern pattern) {
        Op op = TransformFilterPlacement.insertAnyFilter(exprs, patternVarsScope, null);
        if (Var.isVar(graphNode)) {
            patternVarsScope.add(Var.alloc(graphNode));
            op = TransformFilterPlacement.insertAnyFilter(exprs, patternVarsScope, op);
        }
        for (Triple triple : pattern) {
            OpQuadPattern opQuad = TransformFilterPlacement.getQuads(op);
            if (opQuad == null) {
                opQuad = new OpQuadPattern(graphNode, new BasicPattern());
                op = OpSequence.create(op, opQuad);
            }
            opQuad.getBasicPattern().add(triple);
            VarUtils.addVarsFromTriple(patternVarsScope, triple);
            op = TransformFilterPlacement.insertAnyFilter(exprs, patternVarsScope, op);
        }
        return op;
    }

    private static OpQuadPattern getQuads(Op op) {
        Op opTop;
        OpSequence opSeq;
        List<Op> x;
        if (op instanceof OpQuadPattern) {
            return (OpQuadPattern)op;
        }
        if (op instanceof OpSequence && (x = (opSeq = (OpSequence)op).getElements()).size() > 0 && (opTop = x.get(x.size() - 1)) instanceof OpQuadPattern) {
            return (OpQuadPattern)opTop;
        }
        return null;
    }

    private static Op transformFilterSequence(ExprList exprs, Set<Var> varScope, OpSequence opSequence) {
        List<Op> ops = opSequence.getElements();
        Op op = TransformFilterPlacement.insertAnyFilter(exprs, varScope, null);
        for (Op seqElt : ops) {
            seqElt = TransformFilterPlacement.transform(exprs, varScope, seqElt);
            op = OpSequence.create(op, seqElt);
            op = TransformFilterPlacement.insertAnyFilter(exprs, varScope, op);
        }
        return op;
    }

    private static Op insertAnyFilter(ExprList exprs, Set<Var> patternVarsScope, Op op) {
        Iterator<Expr> iter = exprs.iterator();
        while (iter.hasNext()) {
            Expr expr = iter.next();
            Set<Var> exprVars = expr.getVarsMentioned();
            if (!patternVarsScope.containsAll(exprVars)) continue;
            if (op == null) {
                op = OpTable.unit();
            }
            op = OpFilter.filter(expr, op);
            iter.remove();
        }
        return op;
    }

    private static Op buildFilter(ExprList exprs, Op op) {
        if (exprs.isEmpty()) {
            return op;
        }
        Iterator<Expr> iter = exprs.iterator();
        while (iter.hasNext()) {
            Expr expr = iter.next();
            if (op == null) {
                op = OpTable.unit();
            }
            op = OpFilter.filter(expr, op);
            iter.remove();
        }
        return op;
    }
}

