/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.compose.Dyadic;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Union
extends Dyadic
implements Graph {
    public Union(Graph L, Graph R) {
        super(L, R);
    }

    @Override
    public void performAdd(Triple t) {
        this.L.add(t);
    }

    @Override
    public void performDelete(Triple t) {
        this.L.delete(t);
        this.R.delete(t);
    }

    @Override
    public boolean graphBaseContains(Triple t) {
        return this.L.contains(t) || this.R.contains(t);
    }

    @Override
    public ExtendedIterator<Triple> graphBaseFind(TripleMatch t) {
        Set<Triple> seen = CollectionFactory.createHashedSet();
        return Union.recording(this.L.find(t), seen).andThen(Union.rejecting(this.R.find(t), seen));
    }
}

