/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.iterator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratorWithHistory<T>
implements Iterator<T> {
    private List<T> history;
    private Iterator<T> iter;
    private int capacity;
    private boolean hasEnded = false;

    public IteratorWithHistory(Iterator<T> iter, int N) {
        this.iter = iter;
        this.history = new ArrayList<T>(N);
        this.capacity = N;
    }

    @Override
    public boolean hasNext() {
        boolean b = this.iter.hasNext();
        if (!b) {
            this.atEnd();
        }
        return b;
    }

    @Override
    public T next() {
        T item = null;
        try {
            item = this.iter.next();
        }
        catch (NoSuchElementException ex) {
            this.atEnd();
        }
        if (this.history.size() >= this.capacity) {
            this.history.remove(this.history.size() - 1);
        }
        this.history.add(0, item);
        return item;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public T getPrevious(int idx) {
        if (idx >= this.capacity || idx < 0) {
            throw new IndexOutOfBoundsException("Index: " + idx);
        }
        if (idx >= this.history.size()) {
            return null;
        }
        return this.history.get(idx);
    }

    public int currentSize() {
        return this.history.size();
    }

    protected void atEnd() {
        if (!this.hasEnded) {
            this.hasEnded = true;
            this.endReached();
        }
    }

    protected void endReached() {
    }
}

