/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.larq;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.larq.ARQLuceneException;
import com.hp.hpl.jena.query.larq.IndexBuilderModel;
import com.hp.hpl.jena.query.larq.LARQ;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.sparql.ARQNotImplemented;
import java.io.File;
import org.apache.lucene.index.IndexWriter;

public class IndexBuilderSubject
extends IndexBuilderModel {
    Property property;

    public IndexBuilderSubject() {
    }

    public IndexBuilderSubject(IndexWriter existingWriter) {
        super(existingWriter);
    }

    public IndexBuilderSubject(File fileDir) {
        super(fileDir);
    }

    public IndexBuilderSubject(String fileDir) {
        super(fileDir);
    }

    public IndexBuilderSubject(Property p) {
        this();
        this.property = p;
    }

    public IndexBuilderSubject(Property p, IndexWriter existingWriter) {
        super(existingWriter);
        this.property = p;
    }

    public IndexBuilderSubject(Property p, File fileDir) {
        this(fileDir);
        this.property = p;
    }

    public IndexBuilderSubject(Property p, String fileDir) {
        this(fileDir);
        this.property = p;
    }

    public void unindexStatement(Statement s) {
        throw new ARQNotImplemented("unindexStatement");
    }

    public void indexStatement(Statement s) {
        if (!this.indexThisStatement(s)) {
            return;
        }
        try {
            Node subject = s.getSubject().asNode();
            if (!s.getObject().isLiteral() || !LARQ.isString(s.getLiteral())) {
                return;
            }
            Node object = s.getObject().asNode();
            this.index.index(subject, object.getLiteralLexicalForm());
        }
        catch (Exception e2) {
            throw new ARQLuceneException("indexStatement", e2);
        }
    }

    protected boolean indexThisStatement(Statement s) {
        if (this.property == null) {
            return true;
        }
        return s.getPredicate().equals(this.property);
    }
}

