% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unique.R
\name{rray_unique}
\alias{rray_unique}
\alias{rray_unique_loc}
\alias{rray_unique_count}
\title{Find and count unique values in an array}
\usage{
rray_unique(x, axis)

rray_unique_loc(x, axis)

rray_unique_count(x, axis)
}
\arguments{
\item{x}{A vector, matrix, array, or rray.}

\item{axis}{A single integer. The axis to index \code{x} by.}
}
\value{
\itemize{
\item \code{rray_unique()}: an array the same type as \code{x} containing only
unique values. The dimensions of the return value are the same as
\code{x} except on the \code{axis}, which might be smaller than the original
dimension size if any duplicate entries were removed.
\item \code{rray_unique_loc()}: an integer vector, giving locations of
the unique values.
\item \code{rray_unique_count()}: an integer vector of length 1, giving the number
of unique values.
}
}
\description{
\itemize{
\item \code{rray_unique()}: the unique values.
\item \code{rray_unique_loc()}: the locations of the unique values.
\item \code{rray_unique_count()}: the number of unique values.
}
}
\details{
The family of unique functions work in the following manner:
\enumerate{
\item \code{x} is split into pieces using the \code{axis} as the dimension to index along.
\item Each of those pieces is flattened to 1D.
\item The uniqueness test is done between those flattened pieces and the
final output is restored from that result.
}

As an example, if \code{x} has dimensions of \code{(2, 3, 2)} and \code{axis = 2}, then
you can think of \code{x} as being broken into \code{x[, 1]}, \code{x[, 2]} and \code{x[, 3]}.
Each of those three pieces are then flattened, and a vctrs unique function
is called on the list of those flattened inputs.

The result of calling \code{rray_unique()} will always have the same
dimensions as \code{x}, except along \code{axis}, which is allowed to be less than
the original axis size if any duplicate entries are removed.

Unlike the duplicate functions, the unique functions only take a singular
\code{axis} argument, rather than \code{axes}. The reason for this is that if the
unique functions were defined in any other way, they would allow for \emph{ragged
arrays}, which are not defined in rray.

When duplicates are detected, the \emph{first} unique value is used in the result.
}
\examples{
x_dup_rows <- rray(c(1, 1, 3, 3, 2, 2, 4, 4), c(2, 2, 2))
x_dup_rows <- rray_set_row_names(x_dup_rows, c("r1", "r2"))
x_dup_rows <- rray_set_col_names(x_dup_rows, c("c1", "c2"))

# Duplicate rows
# `x_dup_rows[1] == x_dup_rows[2]`
rray_unique(x_dup_rows, 1)

# Duplicate cols
# `x_dup_cols[, 1] == x_dup_cols[, 2]`
x_dup_cols <- rray_transpose(x_dup_rows, c(2, 1, 3))
rray_unique(x_dup_cols, 2)

# Duplicate 3rd dim
# `x_dup_layers[, , 1] == x_dup_layers[, , 2]`
x_dup_layers <- rray_transpose(x_dup_rows, c(2, 3, 1))
rray_unique(x_dup_layers, 3)

# rray_unique_loc() returns an
# integer vector you can use
# to subset out the unique values along
# the axis you are interested in
x_dup_cols[, rray_unique_loc(x_dup_cols, 2L)]

# Only 1 unique column
rray_unique_count(x_dup_cols, 2L)

# But 2 unique rows
rray_unique_count(x_dup_cols, 1L)

}
\seealso{
\code{\link[=rray_duplicate_any]{rray_duplicate_any()}} for functions that work with the dual of
unique values: duplicated values.

\code{\link[vctrs:vec_unique]{vctrs::vec_unique()}} for functions that detect unique values among
any type of vector object.
}
