% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{rray_all_equal}
\alias{rray_all_equal}
\alias{rray_any_not_equal}
\title{Strictly compare arrays}
\usage{
rray_all_equal(x, y)

rray_any_not_equal(x, y)
}
\arguments{
\item{x, y}{Vectors, matrices, arrays, or rrays.}
}
\description{
Unlike \code{\link[=rray_equal]{rray_equal()}} and \code{\link[=rray_not_equal]{rray_not_equal()}}, these functions perform a
strict comparison of two arrays, and return a single logical value.
Specifically:
\itemize{
\item Broadcasting is \emph{not} performed here, as the shape is part of the comparison.
\item The underlying type of the values matter, and \code{1} is treated
as different from \code{1L}.
\item Otherwise, attributes are not compared, so dimension names are ignored.
}
}
\examples{
# This is definitely true!
rray_all_equal(1, 1)

# Different types!
rray_all_equal(1, 1L)

# Different types!
rray_all_equal(rray(1), matrix(1))

# Different shapes!
rray_all_equal(matrix(1), matrix(1, nrow = 2))

# Are any values different?
rray_any_not_equal(c(1, 1), c(1, 2))

# Is the shape different?
rray_any_not_equal(1, c(1, 2))

# Dimension names don't matter
x <- matrix(1, dimnames = list("foo", "bar"))
rray_all_equal(x, matrix(1))

}
