% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename.R
\name{rename_columns}
\alias{rename_columns}
\title{Make a rename columns node (copies columns not renamed).}
\usage{
rename_columns(source, cmap, env = parent.frame())
}
\arguments{
\item{source}{source to rename from.}

\item{cmap}{map written as new column names as keys and old column names as values.}

\item{env}{environment to look to.}
}
\value{
rename columns node.
}
\description{
Make a rename columns node (copies columns not renamed).
}
\examples{

if (requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  d <- rq_copy_to(my_db, 'd',
                   data.frame(AUC = 0.6, R2 = 0.2, z = 3))
  op_tree <- rename_columns(d, c('R2' \%:=\% 'AUC', 'AUC' \%:=\% 'R2'))
  cat(format(op_tree))
  sql <- to_sql(op_tree, my_db)
  cat(sql)
  print(DBI::dbGetQuery(my_db, sql))
  DBI::dbDisconnect(my_db)
}

}
