% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_columns.R
\name{select_columns}
\alias{select_columns}
\title{Make a select columns node (not a relational operation).}
\usage{
select_columns(source, columns)
}
\arguments{
\item{source}{source to select from.}

\item{columns}{list of distinct column names.}
}
\value{
select columns node.
}
\description{
Make a select columns node (not a relational operation).
}
\examples{

if (requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  d <- dbi_copy_to(my_db, 'd',
                   data.frame(AUC = 0.6, R2 = 0.2))
  eqn <- select_columns(d, 'AUC')
  cat(format(eqn))
  sql <- to_sql(eqn, my_db)
  cat(sql)
  print(DBI::dbGetQuery(my_db, sql))
  DBI::dbDisconnect(my_db)
}

}
