% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixedcure.R
\name{fixed_cure}
\alias{fixed_cure}
\title{Builds survival models for diseases with cured fractions using population mortality tables}
\usage{
fixed_cure(formula = NULL, data = NULL, cure_time = 10 * 365.25,
  daily_survival = NULL, population_covariates = NULL,
  dist = c("exponential", "weibull", "lognormal"))
}
\arguments{
\item{formula}{Formula specifying survival function, as used in
\code{\link{prevalence}} with the \code{surv_formula} argument.
\strong{Must be in days}.}

\item{data}{A data frame with the corresponding column names provided in
\code{form}.}

\item{cure_time}{Time-limit at which a patient is considered cured. Note that if this is 0 or negative then
survival will be based purely off the population rates (anything passed into \code{formula} and \code{data} will
be ignored).}

\item{daily_survival}{A data frame comprising population survival as a daily probability for as long as possible,
ideally 100 years (36525 days).
Defaults to using UK population survival from the \code{UKmortality} data set.
It \strong{must contain columns 'age' and 'surv'}, providing the age (in days) and survival
probability at that age respectively.
It can also be stratified by other variables that are found in the survival \code{formula} for this model,
such as sex.}

\item{population_covariates}{A character vector containing fields to stratify population survival by in addition to
age, as descripted in \code{Details} below. These \strong{must} be the names of columns in both \code{data} and
\code{daily_survival}. If not provided then defaults to the fields that are present in both \code{data} and
\code{daily_survival}.}

\item{dist}{The distribution used by the default parametric survival model.}
}
\value{
An object of class \code{fixedcure} that can be passed
  into \code{\link{prevalence}}.
}
\description{
Fits a cure model which assumes that if an individual has survived
 beyond a set time-point then they are considered cured and their mortality reverts
 to population levels.
 Please read the detailed description below for how to use this model.
}
\details{
To model population survival, population mortality tables are required, as specified by the \code{daily_survival}
argument. If not provided, then the default population mortality is that of the UK population, which goes up
to 100 years of age. If a simulated individual has expected lifespan longer than the maximum age in the mortality table
then they are estimated to have died at this age limit,
which is why it is advantageous to provide as many accurate survival probabilities as possible.

Due to the linking with the registry data and the ability for user-specified mortality tables, there are stricter
requirements on the survival models used in cure models than elsewhere. For example, the time-scale of the
survival model specified in \code{formula} \strong{must be in days} so that it matches up with the mortality tables.
Likewise, \strong{age in years must be included as a covariate} in the survival model
}
