% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgGetGeom.R
\name{pgGetGeom}
\alias{pgGetGeom}
\title{Load a PostGIS geometry from a PostgreSQL table/view into R.}
\usage{
pgGetGeom(conn, name, geom = "geom", gid = NULL, other.cols = TRUE,
  clauses = NULL)
}
\arguments{
\item{conn}{A connection object to a PostgreSQL database}

\item{name}{A character string specifying a PostgreSQL schema and
table/view name holding the geometry (e.g., `name =
c("schema","table")`)}

\item{geom}{The name of the geometry column. (Default = "geom")}

\item{gid}{Name of the column in `name` holding the IDs. Should be
unique if additional columns of unique data are being
appended. \code{gid=NULL} (default) automatically creates a
new unique ID for each row in the `sp` object.}

\item{other.cols}{Names of specific columns in the table to
retrieve, in a character vector (e.g. \code{other.cols=c("col1","col2")}.)
The default (\code{other.cols = TRUE}) is to attach
all columns in a Spatial*DataFrame. Setting
\code{other.cols=FALSE} will return a Spatial-only object (no
data frame).}

\item{clauses}{character, additional SQL to append to modify select
query from table. Must begin with an SQL clause (e.g., "WHERE ...",
"ORDER BY ...", "LIMIT ..."); see below for examples.}
}
\value{
sp-class (SpatialPoints*, SpatialMultiPoints*, SpatialLines*, or SpatialPolygons*)
}
\description{
Retrieve point, linestring, or polygon geometries from a PostGIS
table/view, and convert it to an R `sp` object (Spatial* or
Spatial*DataFrame).
}
\examples{
\dontrun{
## Retrieve a Spatial*DataFrame with all data from table
## 'schema.tablename', with geometry in the column 'geom'
pgGetGeom(conn, c("schema", "tablename"))
## Return a Spatial*DataFrame with columns c1 & c2 as data
pgGetGeom(conn, c("schema", "tablename"), other.cols = c("c1","c2"))
## Return a Spatial*-only (no data frame), 
## retaining id from table as rownames
pgGetGeom(conn, c("schema", "tablename"), gid = "table_id",
  other.cols = FALSE)
## Return a Spatial*-only (no data frame), 
## retaining id from table as rownames and with a subset of the data
pgGetGeom(conn, c("schema", "roads"), geom = "roadgeom", gid = "road_ID",
    other.cols = FALSE, clauses  = "WHERE field = 'highway'")
}
}
\author{
David Bucklin \email{dbucklin@ufl.edu}

Mathieu Basille \email{basille@ufl.edu}
}

