% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/browse_phylopic.R
\name{browse_phylopic}
\alias{browse_phylopic}
\title{Browse PhyloPic for a given taxonomic name or uuid}
\usage{
browse_phylopic(name = NULL, uuid = NULL)
}
\arguments{
\item{name}{\code{character}. A taxonomic name. Various taxonomic levels
are supported (e.g. species, genus, family).}

\item{uuid}{\code{character}. A PhyloPic image uuid, as acquired by
\code{\link[=get_uuid]{get_uuid()}}.}
}
\value{
A \code{character} vector of a valid PhyloPic url for the specified
\code{name} or \code{uuid}. If no \code{name} or \code{uuid} is supplied,
the base url of PhyloPic images is returned.
}
\description{
This function provides a convenient way to browse PhyloPic for a given
taxonomic name of uuid.
}
\details{
This function returns a PhyloPic url for an input \code{name} or
\code{uuid} and opens the user's default web browser at this url. If no
\code{name} or \code{uuid} is supplied, the base url of PhyloPic images
is returned and opened instead.
}
\examples{
\dontrun{
url <- browse_phylopic(name = "Acropora cervicornis")
}
}
