% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/RcppExports.R, R/rpg.R
\name{libpq_version}
\alias{enable_postgis}
\alias{encrypt_password}
\alias{get_encoding}
\alias{libpq_version}
\alias{set_encoding}
\alias{set_error_verbosity}
\title{Miscelaneous functions}
\usage{
libpq_version()

encrypt_password(passwd, user)

get_encoding()

set_encoding(encoding)

set_error_verbosity(verbosity)

enable_postgis(schemaname = "postgis")
}
\arguments{
\item{passwd}{the password}

\item{user}{the user name}

\item{encoding}{the character encoding}

\item{verbosity}{one of "terse", "default", "verbose"}

\item{schemaname}{install in this schema}
}
\description{
Various utility functions
}
\details{
\code{enable_postgis} will attempt to install the postgis
extension in the named schema. The default search path is altered to
include the new schema.
}
\examples{
\dontrun{
# try connecting to default database
system("createdb rpgtesting")
connect("rpgtesting")
begin()

libpq_version()
encrypt_password("test", "tester")
get_encoding()
set_encoding("UTF8")
set_error_verbosity("terse")
set_error_verbosity("verbose")
set_error_verbosity("default")
enable_postgis()

# cleanup
rollback()
disconnect()
system("dropdb rpgtesting")}
}
\author{
Timothy H. Keitt
}

