% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_wrapper.R
\name{rolypoly_roll}
\alias{rolypoly_roll}
\title{Main rolypoly wrapper function.}
\usage{
rolypoly_roll(rolypoly = NULL, gwas_data = NULL, block_annotation = NULL,
  block_data = NULL, ld_folder = NULL, bootstrap_iters = 50,
  outlier_threshold = -1, perform_cv = F, n_folds = 10,
  gwas_z_filter = -1, add_spline = F, n_knots = 1, add_poly = F,
  n_degree = 2, run_light = T, gwas_link_parallel = F,
  bootstrap_parallel = F, keep_model = F, keep_gwas = F, ...)
}
\arguments{
\item{rolypoly}{Previous rolypoly run to parts of pipeline.}

\item{gwas_data}{Gwas data for a trait, including snp annotations.}

\item{block_annotation}{Start and end points for blocks}

\item{block_data}{Information about blocks.}

\item{ld_folder}{Folder with LD information.}

\item{bootstrap_iters}{Number bootstrap iterations to perform for inference.}

\item{outlier_threshold}{Set to positive if we want to run robusted regression.}

\item{perform_cv}{If we want to interpret annotation effects do not set this to
T. However, if our goal is prediction accuracy then set this to T.}

\item{n_folds}{number of folds for cross validation}

\item{gwas_z_filter}{Z-score filter for SNPs, helps prevent large effects
biasing inference.}

\item{add_spline}{If we want to fit a spline to maf.}

\item{n_knots}{number of knots to add to the spline.}

\item{add_poly}{If we want to fit a polynomial to maf.}

\item{n_degree}{the degree of the polynomial.}

\item{run_light}{if we want to throw away bootstrap data, and save memory}

\item{gwas_link_parallel}{if user wants to run in gwas linking in parallel,
registerDoParallel must have been run in advance.}

\item{bootstrap_parallel}{if user wants to run in bootstraps in parallel,
registerDoParallel must have been run in advance.}

\item{keep_model}{if we should keep the regression model, can be large.}

\item{keep_gwas}{set to T if we want to include gwas in returned rolypoly object.}

\item{...}{other arguments to pass to cv.glmnet}
}
\value{
rolypoly object
}
\description{
The entry point for rolypoly analysis. If no expression data, we assume
that we are running just the vegas score processing.
}
\examples{
\dontrun{rolypoly_roll(rolypoly)}
}
