% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roll.R
\name{roll_any}
\alias{roll_any}
\title{Rolling Any}
\usage{
roll_any(x, width, min_obs = width, complete_obs = FALSE,
  na_restore = FALSE, online = TRUE)
}
\arguments{
\item{x}{logical matrix or xts object. Rows are observations and columns are variables.}

\item{width}{integer. Window size.}

\item{min_obs}{integer. Minimum number of observations required to have a value within a window,
otherwise result is \code{NA}.}

\item{complete_obs}{logical. If \code{TRUE} then rows containing any missing values are removed,
if \code{FALSE} then each value is used.}

\item{na_restore}{logical. Should missing values be restored?}

\item{online}{logical. Process observations using an online algorithm.}
}
\value{
An object of the same class and dimension as \code{x} with the rolling any.
}
\description{
A function for computing rolling any of time-series data.
}
\examples{
n_vars <- 3
n_obs <- 15
x <- matrix(rnorm(n_obs * n_vars), nrow = n_obs, ncol = n_vars)

# rolling any
result <- roll_any(x < 0, 5)

}
